/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.controller.ControllerService;

public class ControllerServiceConfiguration {
    private final ControllerService service;
    private final AtomicBoolean enabled = new AtomicBoolean(false);
    private String annotationData;
    private Map<PropertyDescriptor, String> properties = new HashMap<PropertyDescriptor, String>();

    public ControllerServiceConfiguration(ControllerService service) {
        this.service = service;
    }

    public ControllerService getService() {
        return this.service;
    }

    public void setEnabled(boolean enabled) {
        this.enabled.set(enabled);
    }

    public boolean isEnabled() {
        return this.enabled.get();
    }

    public void setProperties(Map<PropertyDescriptor, String> props) {
        this.properties = new HashMap<PropertyDescriptor, String>(props);
    }

    public String getProperty(PropertyDescriptor descriptor) {
        String value = this.properties.get(descriptor);
        if (value == null) {
            return descriptor.getDefaultValue();
        }
        return value;
    }

    public void setAnnotationData(String annotationData) {
        this.annotationData = annotationData;
    }

    public String getAnnotationData() {
        return this.annotationData;
    }

    public Map<PropertyDescriptor, String> getProperties() {
        return Collections.unmodifiableMap(this.properties);
    }
}

