/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.nifi.processor.Processor;
import org.apache.nifi.provenance.ProvenanceEventRecord;
import org.apache.nifi.provenance.ProvenanceReporter;
import org.apache.nifi.util.MockFlowFileQueue;
import org.apache.nifi.util.MockProvenanceReporter;

public class SharedSessionState {
    private final MockFlowFileQueue flowFileQueue;
    private final ProvenanceReporter provenanceReporter;
    private final Processor processor;
    private final AtomicLong flowFileIdGenerator;
    private final ConcurrentMap<String, AtomicLong> counterMap = new ConcurrentHashMap<String, AtomicLong>();
    private final List<ProvenanceEventRecord> events = new ArrayList<ProvenanceEventRecord>();

    public SharedSessionState(Processor processor, AtomicLong flowFileIdGenerator) {
        this.flowFileQueue = new MockFlowFileQueue();
        this.provenanceReporter = new MockProvenanceReporter(null, this, UUID.randomUUID().toString(), "N/A");
        this.flowFileIdGenerator = flowFileIdGenerator;
        this.processor = processor;
    }

    void addProvenanceEvents(Collection<ProvenanceEventRecord> events) {
        this.events.addAll(events);
    }

    void clearProvenanceEvents() {
        this.events.clear();
    }

    public List<ProvenanceEventRecord> getProvenanceEvents() {
        return new ArrayList<ProvenanceEventRecord>(this.events);
    }

    public MockFlowFileQueue getFlowFileQueue() {
        return this.flowFileQueue;
    }

    public ProvenanceReporter getProvenanceReporter() {
        return this.provenanceReporter;
    }

    public long nextFlowFileId() {
        return this.flowFileIdGenerator.getAndIncrement();
    }

    public void adjustCounter(String name, long delta) {
        AtomicLong existingCounter;
        AtomicLong counter = (AtomicLong)this.counterMap.get(name);
        if (counter == null && (existingCounter = this.counterMap.putIfAbsent(name, counter = new AtomicLong(0L))) != null) {
            counter = existingCounter;
        }
        counter.addAndGet(delta);
    }

    public Long getCounterValue(String name) {
        AtomicLong counterValue = (AtomicLong)this.counterMap.get(name);
        return counterValue == null ? null : Long.valueOf(counterValue.get());
    }
}

