/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.util;

import java.util.Collection;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.nifi.controller.queue.QueueSize;
import org.apache.nifi.util.MockFlowFile;

public class MockFlowFileQueue {
    private final BlockingQueue<MockFlowFile> queue;
    private final ReadWriteLock rwLock = new ReentrantReadWriteLock();
    private final Lock readLock = this.rwLock.readLock();
    private final Lock writeLock = this.rwLock.writeLock();

    public MockFlowFileQueue() {
        this.queue = new LinkedBlockingQueue<MockFlowFile>();
    }

    public void offer(MockFlowFile flowFile) {
        this.writeLock.lock();
        try {
            this.queue.offer(flowFile);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public MockFlowFile poll() {
        this.writeLock.lock();
        try {
            MockFlowFile mockFlowFile = (MockFlowFile)this.queue.poll();
            return mockFlowFile;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void addAll(Collection<MockFlowFile> flowFiles) {
        this.writeLock.lock();
        try {
            this.queue.addAll(flowFiles);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QueueSize size() {
        this.readLock.lock();
        try {
            int count = this.queue.size();
            long contentSize = 0L;
            for (MockFlowFile flowFile : this.queue) {
                contentSize += flowFile.getSize();
            }
            QueueSize queueSize = new QueueSize(count, contentSize);
            return queueSize;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public boolean isEmpty() {
        return this.size().getObjectCount() == 0;
    }
}

