/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.authorization;

import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.nifi.authorization.AbstractPolicyBasedAuthorizer;
import org.apache.nifi.authorization.AccessPolicy;
import org.apache.nifi.authorization.AuthorizationAuditor;
import org.apache.nifi.authorization.AuthorizationRequest;
import org.apache.nifi.authorization.AuthorizationResult;
import org.apache.nifi.authorization.AuthorizerConfigurationContext;
import org.apache.nifi.authorization.AuthorizerInitializationContext;
import org.apache.nifi.authorization.Group;
import org.apache.nifi.authorization.RequestAction;
import org.apache.nifi.authorization.User;
import org.apache.nifi.authorization.UsersAndAccessPolicies;
import org.apache.nifi.authorization.exception.AuthorizationAccessException;
import org.apache.nifi.authorization.exception.AuthorizerCreationException;
import org.apache.nifi.authorization.exception.AuthorizerDestructionException;

public class MockPolicyBasedAuthorizer
extends AbstractPolicyBasedAuthorizer
implements AuthorizationAuditor {
    private Set<Group> groups = new HashSet<Group>();
    private Set<User> users = new HashSet<User>();
    private Set<AccessPolicy> policies = new HashSet<AccessPolicy>();
    private Set<AuthorizationRequest> audited = new HashSet<AuthorizationRequest>();

    public MockPolicyBasedAuthorizer() {
    }

    public MockPolicyBasedAuthorizer(Set<Group> groups, Set<User> users, Set<AccessPolicy> policies) {
        if (groups != null) {
            this.groups.addAll(groups);
        }
        if (users != null) {
            this.users.addAll(users);
        }
        if (policies != null) {
            this.policies.addAll(policies);
        }
    }

    public Group doAddGroup(Group group) throws AuthorizationAccessException {
        this.groups.add(group);
        return group;
    }

    public Group getGroup(String identifier) throws AuthorizationAccessException {
        return this.groups.stream().filter(g -> g.getIdentifier().equals(identifier)).findFirst().get();
    }

    public Group getGroupByName(String name) throws AuthorizationAccessException {
        return this.groups.stream().filter(g -> g.getName().equals(name)).findFirst().get();
    }

    public Group doUpdateGroup(Group group) throws AuthorizationAccessException {
        this.deleteGroup(group);
        return this.addGroup(group);
    }

    public Group deleteGroup(Group group) throws AuthorizationAccessException {
        this.groups.remove(group);
        return group;
    }

    public Set<Group> getGroups() throws AuthorizationAccessException {
        return this.groups;
    }

    public User doAddUser(User user) throws AuthorizationAccessException {
        this.users.add(user);
        return user;
    }

    public User getUser(String identifier) throws AuthorizationAccessException {
        return this.users.stream().filter(u -> u.getIdentifier().equals(identifier)).findFirst().get();
    }

    public User getUserByIdentity(String identity) throws AuthorizationAccessException {
        return this.users.stream().filter(u -> u.getIdentity().equals(identity)).findFirst().get();
    }

    public User doUpdateUser(User user) throws AuthorizationAccessException {
        this.deleteUser(user);
        return this.addUser(user);
    }

    public User deleteUser(User user) throws AuthorizationAccessException {
        this.users.remove(user);
        return user;
    }

    public Set<User> getUsers() throws AuthorizationAccessException {
        return this.users;
    }

    protected AccessPolicy doAddAccessPolicy(AccessPolicy accessPolicy) throws AuthorizationAccessException {
        this.policies.add(accessPolicy);
        return accessPolicy;
    }

    public AccessPolicy getAccessPolicy(String identifier) throws AuthorizationAccessException {
        return this.policies.stream().filter(p -> p.getIdentifier().equals(identifier)).findFirst().get();
    }

    public AccessPolicy updateAccessPolicy(AccessPolicy accessPolicy) throws AuthorizationAccessException {
        this.deleteAccessPolicy(accessPolicy);
        return this.addAccessPolicy(accessPolicy);
    }

    public AccessPolicy deleteAccessPolicy(AccessPolicy policy) throws AuthorizationAccessException {
        this.policies.remove(policy);
        return policy;
    }

    public Set<AccessPolicy> getAccessPolicies() throws AuthorizationAccessException {
        return this.policies;
    }

    public UsersAndAccessPolicies getUsersAndAccessPolicies() throws AuthorizationAccessException {
        return new UsersAndAccessPolicies(){

            public AccessPolicy getAccessPolicy(String resourceIdentifier, RequestAction action) {
                return MockPolicyBasedAuthorizer.this.policies.stream().filter(policy -> policy.getResource().equals(resourceIdentifier) && policy.getAction().equals((Object)action)).findFirst().orElse(null);
            }

            public User getUser(String identity) {
                return MockPolicyBasedAuthorizer.this.getUserByIdentity(identity);
            }

            public Set<Group> getGroups(String userIdentity) {
                User user = MockPolicyBasedAuthorizer.this.getUserByIdentity(userIdentity);
                if (user == null) {
                    return new HashSet<Group>();
                }
                return MockPolicyBasedAuthorizer.this.groups.stream().filter(g -> g.getUsers().contains(user.getIdentifier())).collect(Collectors.toSet());
            }
        };
    }

    public void auditAccessAttempt(AuthorizationRequest request, AuthorizationResult result) {
        this.audited.add(request);
    }

    public boolean isAudited(AuthorizationRequest request) {
        return this.audited.contains(request);
    }

    public void initialize(AuthorizerInitializationContext initializationContext) throws AuthorizerCreationException {
    }

    public void doOnConfigured(AuthorizerConfigurationContext configurationContext) throws AuthorizerCreationException {
    }

    public void preDestruction() throws AuthorizerDestructionException {
    }

    public void backupPoliciesUsersAndGroups() {
    }

    public void purgePoliciesUsersAndGroups() {
        this.groups.clear();
        this.users.clear();
        this.policies.clear();
    }
}

