/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.security.maprsasl;

import java.lang.reflect.Method;
import java.security.Provider;
import java.util.Map;
import javax.security.auth.callback.CallbackHandler;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslClientFactory;
import javax.security.sasl.SaslException;
import org.apache.nifi.util.hpe.HpePropertiesURLClassLoader;

public class IsolatedMaprSaslProvider
extends Provider {
    public IsolatedMaprSaslProvider() {
        super("MaprSasl", "1.0", "Dependency isolated Mapr SASL provider");
        this.put("SaslClientFactory.MAPR-SECURITY", IsolatedMaprSaslClientFactory.class.getName());
    }

    private static Class<?> loadClassFromHpeDeps(String className) throws ClassNotFoundException {
        HpePropertiesURLClassLoader hpePropertiesURLClassLoader = new HpePropertiesURLClassLoader();
        return hpePropertiesURLClassLoader.loadClass(className);
    }

    public static class IsolatedMaprSaslClientFactory
    implements SaslClientFactory {
        private static final String MAPR_SASL_CLIENT_CLASS_NAME = "com.mapr.security.maprsasl.MaprSaslClient$SaslMaprClientFactory";
        private volatile Object factoryInstance;
        private volatile Method getMechanismNamesMethod;
        private volatile Method createSaslClientMethod;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void initFactory() throws Exception {
            if (this.factoryInstance != null) {
                return;
            }
            IsolatedMaprSaslClientFactory isolatedMaprSaslClientFactory = this;
            synchronized (isolatedMaprSaslClientFactory) {
                if (this.factoryInstance == null) {
                    Class<?> maprSaslClientFactoryClass = IsolatedMaprSaslProvider.loadClassFromHpeDeps(MAPR_SASL_CLIENT_CLASS_NAME);
                    this.factoryInstance = maprSaslClientFactoryClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                    this.getMechanismNamesMethod = maprSaslClientFactoryClass.getMethod("getMechanismNames", Map.class);
                    this.createSaslClientMethod = maprSaslClientFactoryClass.getMethod("createSaslClient", String[].class, String.class, String.class, String.class, Map.class, CallbackHandler.class);
                }
            }
        }

        @Override
        public String[] getMechanismNames(Map<String, ?> props) {
            try {
                this.initFactory();
                return (String[])this.getMechanismNamesMethod.invoke(this.factoryInstance, props);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public SaslClient createSaslClient(String[] mechanisms, String authorizationId, String protocol, String serverName, Map<String, ?> props, CallbackHandler cbh) throws SaslException {
            try {
                this.initFactory();
                return (SaslClient)this.createSaslClientMethod.invoke(this.factoryInstance, mechanisms, authorizationId, protocol, serverName, props, cbh);
            }
            catch (Exception e) {
                throw new SaslException("MapR SASL client creation failed", e);
            }
        }
    }
}

