/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.lookup.db;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.Expiry;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnEnabled;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.controller.ConfigurationContext;
import org.apache.nifi.controller.ControllerServiceInitializationContext;
import org.apache.nifi.dbcp.DBCPService;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.lookup.LookupFailureException;
import org.apache.nifi.lookup.RecordLookupService;
import org.apache.nifi.lookup.db.AbstractDatabaseLookupService;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.serialization.record.Record;
import org.apache.nifi.serialization.record.ResultSetRecordSet;
import org.apache.nifi.util.Tuple;
import org.apache.nifi.util.db.JdbcProperties;

@Tags(value={"lookup", "cache", "enrich", "join", "rdbms", "database", "reloadable", "key", "value", "record"})
@CapabilityDescription(value="A relational-database-based lookup service. When the lookup key is found in the database, the specified columns (or all if Lookup Value Columns are not specified) are returned as a Record. Only one row will be returned for each lookup, duplicate database entries are ignored.")
public class DatabaseRecordLookupService
extends AbstractDatabaseLookupService
implements RecordLookupService {
    private volatile Cache<Tuple<String, Object>, Record> cache;
    static final PropertyDescriptor LOOKUP_VALUE_COLUMNS = new PropertyDescriptor.Builder().name("dbrecord-lookup-value-columns").displayName("Lookup Value Columns").description("A comma-delimited list of columns in the table that will be returned when the lookup key matches. Note that this may be case-sensitive depending on the database.").required(false).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).build();

    protected void init(ControllerServiceInitializationContext context) {
        ArrayList<PropertyDescriptor> properties = new ArrayList<PropertyDescriptor>();
        properties.add(DBCP_SERVICE);
        properties.add(TABLE_NAME);
        properties.add(LOOKUP_KEY_COLUMN);
        properties.add(LOOKUP_VALUE_COLUMNS);
        properties.add(CACHE_SIZE);
        properties.add(CLEAR_CACHE_ON_ENABLED);
        properties.add(CACHE_EXPIRATION);
        properties.add(JdbcProperties.DEFAULT_PRECISION);
        properties.add(JdbcProperties.DEFAULT_SCALE);
        this.properties = Collections.unmodifiableList(properties);
    }

    @OnEnabled
    public void onEnabled(ConfigurationContext context) {
        long durationNanos;
        this.dbcpService = (DBCPService)context.getProperty(DBCP_SERVICE).asControllerService(DBCPService.class);
        this.lookupKeyColumn = context.getProperty(LOOKUP_KEY_COLUMN).evaluateAttributeExpressions().getValue();
        int cacheSize = context.getProperty(CACHE_SIZE).evaluateAttributeExpressions().asInteger();
        boolean clearCache = context.getProperty(CLEAR_CACHE_ON_ENABLED).asBoolean();
        long l = durationNanos = context.getProperty(CACHE_EXPIRATION).isSet() ? context.getProperty(CACHE_EXPIRATION).evaluateAttributeExpressions().asTimePeriod(TimeUnit.NANOSECONDS) : 0L;
        if (this.cache == null || cacheSize > 0 && clearCache) {
            this.cache = durationNanos > 0L ? Caffeine.newBuilder().maximumSize((long)cacheSize).expireAfter((Expiry)new Expiry<Tuple<String, Object>, Record>(){

                public long expireAfterCreate(Tuple<String, Object> stringObjectTuple, Record record, long currentTime) {
                    return durationNanos;
                }

                public long expireAfterUpdate(Tuple<String, Object> stringObjectTuple, Record record, long currentTime, long currentDuration) {
                    return currentDuration;
                }

                public long expireAfterRead(Tuple<String, Object> stringObjectTuple, Record record, long currentTime, long currentDuration) {
                    return currentDuration;
                }
            }).build() : Caffeine.newBuilder().maximumSize((long)cacheSize).build();
        }
    }

    public Optional<Record> lookup(Map<String, Object> coordinates) throws LookupFailureException {
        return this.lookup(coordinates, null);
    }

    public Optional<Record> lookup(Map<String, Object> coordinates, Map<String, String> context) throws LookupFailureException {
        if (coordinates == null) {
            return Optional.empty();
        }
        Object key = coordinates.get("key");
        if (StringUtils.isBlank((CharSequence)key.toString())) {
            return Optional.empty();
        }
        String tableName = this.getProperty(TABLE_NAME).evaluateAttributeExpressions(context).getValue();
        String lookupValueColumnsList = this.getProperty(LOOKUP_VALUE_COLUMNS).evaluateAttributeExpressions(context).getValue();
        Integer defaultPrecision = this.getProperty(JdbcProperties.DEFAULT_PRECISION).evaluateAttributeExpressions(context).asInteger();
        Integer defaultScale = this.getProperty(JdbcProperties.DEFAULT_SCALE).evaluateAttributeExpressions(context).asInteger();
        LinkedHashSet lookupValueColumnsSet = new LinkedHashSet();
        if (lookupValueColumnsList != null) {
            Stream.of(lookupValueColumnsList).flatMap(path -> Arrays.stream(path.split(","))).filter(DatabaseRecordLookupService::isNotBlank).map(String::trim).forEach(lookupValueColumnsSet::add);
        }
        String lookupValueColumns = lookupValueColumnsSet.isEmpty() ? "*" : String.join((CharSequence)",", lookupValueColumnsSet);
        Tuple cacheLookupKey = new Tuple((Object)tableName, key);
        Record foundRecord = (Record)this.cache.get((Object)cacheLookupKey, k -> null);
        if (foundRecord == null) {
            String selectQuery = "SELECT " + lookupValueColumns + " FROM " + tableName + " WHERE " + this.lookupKeyColumn + " = ?";
            try (Connection con = this.dbcpService.getConnection(context);
                 PreparedStatement st = con.prepareStatement(selectQuery);){
                st.setObject(1, key);
                ResultSet resultSet = st.executeQuery();
                ResultSetRecordSet resultSetRecordSet = new ResultSetRecordSet(resultSet, null, defaultPrecision.intValue(), defaultScale.intValue());
                foundRecord = resultSetRecordSet.next();
                if (foundRecord != null) {
                    this.cache.put((Object)cacheLookupKey, (Object)foundRecord);
                }
            }
            catch (SQLException se) {
                throw new LookupFailureException("Error executing SQL statement: " + selectQuery + "for value " + key.toString() + " : " + (se.getCause() == null ? se.getMessage() : se.getCause().getMessage()), (Throwable)se);
            }
            catch (IOException ioe) {
                throw new LookupFailureException("Error retrieving result set for SQL statement: " + selectQuery + "for value " + key.toString() + " : " + (ioe.getCause() == null ? ioe.getMessage() : ioe.getCause().getMessage()), (Throwable)ioe);
            }
        }
        return Optional.ofNullable(foundRecord);
    }

    private static boolean isNotBlank(String value) {
        return value != null && !value.trim().isEmpty();
    }

    public Set<String> getRequiredKeys() {
        return REQUIRED_KEYS;
    }
}

