/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.kudu;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.kudu.client.Operation;
import org.apache.kudu.client.RowError;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.processors.kudu.PutKuduResult;

public class StandardPutKuduResult
extends PutKuduResult {
    private final Map<Operation, FlowFile> operationFlowFileMap = new HashMap<Operation, FlowFile>();
    private final List<RowError> pendingRowErrors = new ArrayList<RowError>();
    private final Map<FlowFile, List<RowError>> flowFileRowErrorsMap = new HashMap<FlowFile, List<RowError>>();

    @Override
    public void recordOperation(Operation operation) {
        this.operationFlowFileMap.put(operation, this.flowFile);
    }

    @Override
    public void addError(RowError rowError) {
        this.pendingRowErrors.add(rowError);
    }

    @Override
    public void resolveFlowFileToRowErrorAssociations() {
        this.flowFileRowErrorsMap.putAll(this.pendingRowErrors.stream().filter(e -> this.operationFlowFileMap.get(e.getOperation()) != null).collect(Collectors.groupingBy(e -> this.operationFlowFileMap.get(e.getOperation()))));
        this.pendingRowErrors.clear();
    }

    @Override
    public boolean hasRowErrorsOrFailures() {
        if (!this.flowFileFailures.isEmpty()) {
            return true;
        }
        return this.flowFileRowErrorsMap.entrySet().stream().anyMatch(entry -> !((List)entry.getValue()).isEmpty());
    }

    @Override
    public List<RowError> getRowErrorsForFlowFile(FlowFile flowFile) {
        return this.flowFileRowErrorsMap.getOrDefault(flowFile, Collections.EMPTY_LIST);
    }
}

