/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.kudu;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.kudu.client.Operation;
import org.apache.kudu.client.RowError;
import org.apache.nifi.flowfile.FlowFile;

public abstract class PutKuduResult {
    protected FlowFile flowFile = null;
    protected final Map<FlowFile, Object> flowFileFailures = new HashMap<FlowFile, Object>();
    private final Set<FlowFile> processedFlowFiles = new HashSet<FlowFile>();
    private final Map<FlowFile, Integer> processedRecords = new HashMap<FlowFile, Integer>();

    public void setFlowFile(FlowFile flowFile) {
        this.flowFile = flowFile;
        this.processedFlowFiles.add(flowFile);
    }

    public Set<FlowFile> getProcessedFlowFiles() {
        return this.processedFlowFiles;
    }

    public int getProcessedRecordsForFlowFile(FlowFile flowFile) {
        return this.processedRecords.getOrDefault(flowFile, 0);
    }

    public void incrementProcessedRecordsForFlowFile() {
        int newCount = this.processedRecords.getOrDefault(this.flowFile, 0) + 1;
        this.processedRecords.put(this.flowFile, newCount);
    }

    public abstract void recordOperation(Operation var1);

    public abstract void addError(RowError var1);

    public void addErrors(List<RowError> rowErrors) {
        for (RowError rowError : rowErrors) {
            this.addError(rowError);
        }
    }

    public void addFailure(Object failure) {
        if (this.flowFileFailures.containsKey(this.flowFile)) {
            throw new IllegalStateException("A failure has already previously occurred while processing FlowFile.");
        }
        this.flowFileFailures.put(this.flowFile, failure);
    }

    public void resolveFlowFileToRowErrorAssociations() {
    }

    public abstract boolean hasRowErrorsOrFailures();

    public boolean isFlowFileProcessedSuccessfully(FlowFile flowFile) {
        return !this.flowFileFailures.containsKey(flowFile);
    }

    public Object getFailureForFlowFile(FlowFile flowFile) {
        return this.flowFileFailures.get(flowFile);
    }

    public abstract List<RowError> getRowErrorsForFlowFile(FlowFile var1);
}

