/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.kerberos;

import java.util.Collections;
import java.util.List;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.controller.ConfigurationContext;
import org.apache.nifi.kerberos.AbstractKerberosUserService;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.security.krb.KerberosPasswordUser;
import org.apache.nifi.security.krb.KerberosUser;

@CapabilityDescription(value="Provides a mechanism for creating a KerberosUser from a principal and password that other components are able to use in order to perform authentication using Kerberos.")
@Tags(value={"Kerberos", "Password", "Principal", "Credentials", "Authentication", "Security"})
public class KerberosPasswordUserService
extends AbstractKerberosUserService {
    static final PropertyDescriptor PASSWORD = new PropertyDescriptor.Builder().name("Kerberos Password").description("Kerberos password associated with the principal.").addValidator(StandardValidators.NON_EMPTY_VALIDATOR).required(true).sensitive(true).build();
    private volatile String password;

    @Override
    protected List<PropertyDescriptor> getAdditionalProperties() {
        return Collections.singletonList(PASSWORD);
    }

    @Override
    protected void setAdditionalConfiguredValues(ConfigurationContext context) {
        this.password = context.getProperty(PASSWORD).evaluateAttributeExpressions().getValue();
    }

    public KerberosUser createKerberosUser() {
        return new KerberosPasswordUser(this.getPrincipal(), this.password);
    }
}

