/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.kerberos;

import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.authentication.AuthenticationResponse;
import org.apache.nifi.authentication.LoginCredentials;
import org.apache.nifi.authentication.LoginIdentityProvider;
import org.apache.nifi.authentication.LoginIdentityProviderConfigurationContext;
import org.apache.nifi.authentication.LoginIdentityProviderInitializationContext;
import org.apache.nifi.authentication.exception.IdentityAccessException;
import org.apache.nifi.authentication.exception.InvalidLoginCredentialsException;
import org.apache.nifi.authentication.exception.ProviderCreationException;
import org.apache.nifi.authentication.exception.ProviderDestructionException;
import org.apache.nifi.kerberos.KerberosUserDetailsService;
import org.apache.nifi.kerberos.parser.KerberosPrincipalParser;
import org.apache.nifi.util.FormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.kerberos.authentication.KerberosAuthenticationProvider;
import org.springframework.security.kerberos.authentication.KerberosClient;
import org.springframework.security.kerberos.authentication.sun.SunJaasKerberosClient;

public class KerberosProvider
implements LoginIdentityProvider {
    private static final Logger logger = LoggerFactory.getLogger(KerberosProvider.class);
    private KerberosAuthenticationProvider provider;
    private String issuer;
    private String defaultRealm;
    private long expiration;

    public final void initialize(LoginIdentityProviderInitializationContext initializationContext) throws ProviderCreationException {
        this.issuer = this.getClass().getSimpleName();
    }

    public final void onConfigured(LoginIdentityProviderConfigurationContext configurationContext) throws ProviderCreationException {
        String rawExpiration = configurationContext.getProperty("Authentication Expiration");
        if (StringUtils.isBlank((CharSequence)rawExpiration)) {
            throw new ProviderCreationException("The Authentication Expiration must be specified.");
        }
        try {
            this.expiration = Double.valueOf(FormatUtils.getPreciseTimeDuration((String)rawExpiration, (TimeUnit)TimeUnit.MILLISECONDS)).longValue();
        }
        catch (IllegalArgumentException iae) {
            throw new ProviderCreationException(String.format("The Expiration Duration '%s' is not a valid time duration", rawExpiration));
        }
        this.defaultRealm = configurationContext.getProperty("Default Realm");
        if (StringUtils.isNotBlank((CharSequence)this.defaultRealm) && this.defaultRealm.contains("@")) {
            throw new ProviderCreationException(String.format("The Default Realm '%s' must not contain \"@\"", this.defaultRealm));
        }
        this.provider = new KerberosAuthenticationProvider();
        SunJaasKerberosClient client = new SunJaasKerberosClient();
        client.setDebug(true);
        this.provider.setKerberosClient((KerberosClient)client);
        this.provider.setUserDetailsService((UserDetailsService)new KerberosUserDetailsService());
    }

    public final AuthenticationResponse authenticate(LoginCredentials credentials) throws InvalidLoginCredentialsException, IdentityAccessException {
        if (this.provider == null) {
            throw new IdentityAccessException("The Kerberos authentication provider is not initialized.");
        }
        try {
            String identity;
            String rawPrincipal = credentials.getUsername();
            String parsedRealm = KerberosPrincipalParser.getRealm(rawPrincipal);
            boolean realmInRawPrincipal = StringUtils.isNotBlank((CharSequence)parsedRealm);
            if (realmInRawPrincipal) {
                identity = rawPrincipal;
                logger.debug("Realm was specified in principal {}, default realm was not added to the identity being authenticated", (Object)rawPrincipal);
            } else if (StringUtils.isNotBlank((CharSequence)this.defaultRealm)) {
                identity = StringUtils.joinWith((String)"@", (Object[])new Object[]{rawPrincipal, this.defaultRealm});
                logger.debug("Realm was not specified in principal {}, default realm {} was added to the identity being authenticated", (Object)rawPrincipal, (Object)this.defaultRealm);
            } else {
                identity = rawPrincipal;
                logger.debug("Realm was not specified in principal {}, default realm is blank and was not added to the identity being authenticated", (Object)rawPrincipal);
            }
            UsernamePasswordAuthenticationToken token = new UsernamePasswordAuthenticationToken((Object)identity, (Object)credentials.getPassword());
            if (logger.isDebugEnabled()) {
                logger.debug("Created authentication token for principal {} with name {} and is authenticated {}", new Object[]{token.getPrincipal(), token.getName(), token.isAuthenticated()});
            }
            Authentication authentication = this.provider.authenticate((Authentication)token);
            if (logger.isDebugEnabled()) {
                logger.debug("Ran provider.authenticate() and returned authentication for principal {} with name {} and is authenticated {}", new Object[]{authentication.getPrincipal(), authentication.getName(), authentication.isAuthenticated()});
            }
            return new AuthenticationResponse(authentication.getName(), identity, this.expiration, this.issuer);
        }
        catch (AuthenticationException e) {
            throw new InvalidLoginCredentialsException(e.getMessage(), (Throwable)e);
        }
    }

    public final void preDestruction() throws ProviderDestructionException {
    }
}

