/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.kafka.shared.validation;

import org.apache.nifi.components.PropertyValue;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.deprecation.log.DeprecationLogger;
import org.apache.nifi.deprecation.log.DeprecationLoggerFactory;
import org.apache.nifi.kafka.shared.component.KafkaClientComponent;

public class KafkaDeprecationValidator {
    public static void validate(Class<?> componentClass, String identifier, ValidationContext validationContext) {
        DeprecationLogger deprecationLogger = DeprecationLoggerFactory.getLogger(componentClass);
        PropertyValue credentialsServiceProperty = validationContext.getProperty(KafkaClientComponent.KERBEROS_CREDENTIALS_SERVICE);
        PropertyValue principalProperty = validationContext.getProperty(KafkaClientComponent.KERBEROS_PRINCIPAL).evaluateAttributeExpressions();
        PropertyValue keyTabProperty = validationContext.getProperty(KafkaClientComponent.KERBEROS_KEYTAB).evaluateAttributeExpressions();
        if (credentialsServiceProperty.isSet()) {
            deprecationLogger.warn("{}[id={}] [{}] Property should be replaced with [{}] Property", new Object[]{componentClass.getSimpleName(), identifier, KafkaClientComponent.KERBEROS_CREDENTIALS_SERVICE.getDisplayName(), KafkaClientComponent.SELF_CONTAINED_KERBEROS_USER_SERVICE.getDisplayName()});
        }
        if (principalProperty.isSet() || keyTabProperty.isSet()) {
            deprecationLogger.warn("{}[id={}] [{}] and [{}] Properties should be replaced with [{}] Property", new Object[]{componentClass.getSimpleName(), identifier, KafkaClientComponent.KERBEROS_PRINCIPAL.getDisplayName(), KafkaClientComponent.KERBEROS_KEYTAB.getDisplayName(), KafkaClientComponent.SELF_CONTAINED_KERBEROS_USER_SERVICE.getDisplayName()});
        }
    }
}

