/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.kafka.shared.validation;

import java.util.Set;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.components.Validator;
import org.apache.nifi.kafka.shared.property.provider.StandardKafkaPropertyNameProvider;

public class DynamicPropertyValidator
implements Validator {
    private static final String PARTITIONS_PROPERTY_PREFIX = "partitions";
    private final Set<String> clientPropertyNames;

    public DynamicPropertyValidator(Class<?> kafkaClientClass) {
        StandardKafkaPropertyNameProvider provider = new StandardKafkaPropertyNameProvider(kafkaClientClass);
        this.clientPropertyNames = provider.getPropertyNames();
    }

    public ValidationResult validate(String subject, String input, ValidationContext context) {
        ValidationResult.Builder builder = new ValidationResult.Builder();
        builder.subject(subject);
        if (subject.startsWith(PARTITIONS_PROPERTY_PREFIX)) {
            builder.valid(true);
        } else {
            boolean valid = this.clientPropertyNames.contains(subject);
            builder.valid(valid);
            builder.explanation("must be a known Kafka client configuration property");
        }
        return builder.build();
    }
}

