/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.kafka.shared.property;

import java.util.Arrays;
import java.util.Optional;
import org.apache.nifi.components.DescribedValue;

public enum SaslMechanism implements DescribedValue
{
    GSSAPI("GSSAPI", "GSSAPI", "General Security Services API for Kerberos authentication"),
    PLAIN("PLAIN", "PLAIN", "Plain username and password authentication"),
    SCRAM_SHA_256("SCRAM-SHA-256", "SCRAM-SHA-256", "Salted Challenge Response Authentication Mechanism using SHA-512 with username and password"),
    SCRAM_SHA_512("SCRAM-SHA-512", "SCRAM-SHA-512", "Salted Challenge Response Authentication Mechanism using SHA-256 with username and password");

    private final String value;
    private final String displayName;
    private final String description;

    private SaslMechanism(String value, String displayName, String description) {
        this.value = value;
        this.displayName = displayName;
        this.description = description;
    }

    public static SaslMechanism getSaslMechanism(String value) {
        Optional<SaslMechanism> foundSaslMechanism = Arrays.stream(SaslMechanism.values()).filter(saslMechanism -> saslMechanism.getValue().equals(value)).findFirst();
        return foundSaslMechanism.orElseThrow(() -> new IllegalArgumentException(String.format("SaslMechanism value [%s] not found", value)));
    }

    public String getValue() {
        return this.value;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getDescription() {
        return this.description;
    }
}

