/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.kafka.shared.login;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import javax.security.auth.login.AppConfigurationEntry;
import org.apache.nifi.context.PropertyContext;
import org.apache.nifi.kafka.shared.component.KafkaClientComponent;
import org.apache.nifi.kafka.shared.login.LoginConfigProvider;
import org.apache.nifi.kerberos.KerberosUserService;
import org.apache.nifi.kerberos.SelfContainedKerberosUserService;
import org.apache.nifi.security.krb.KerberosUser;

public class KerberosUserServiceLoginConfigProvider
implements LoginConfigProvider {
    private static final String SPACE = " ";
    private static final String EQUALS = "=";
    private static final String DOUBLE_QUOTE = "\"";
    private static final String SEMI_COLON = ";";
    private static final Map<AppConfigurationEntry.LoginModuleControlFlag, String> CONTROL_FLAGS = new LinkedHashMap<AppConfigurationEntry.LoginModuleControlFlag, String>();

    @Override
    public String getConfiguration(PropertyContext context) {
        KerberosUserService kerberosUserService = (KerberosUserService)context.getProperty(KafkaClientComponent.SELF_CONTAINED_KERBEROS_USER_SERVICE).asControllerService(SelfContainedKerberosUserService.class);
        KerberosUser kerberosUser = kerberosUserService.createKerberosUser();
        AppConfigurationEntry configurationEntry = kerberosUser.getConfigurationEntry();
        StringBuilder builder = new StringBuilder();
        String loginModuleName = configurationEntry.getLoginModuleName();
        builder.append(loginModuleName);
        AppConfigurationEntry.LoginModuleControlFlag controlFlag = configurationEntry.getControlFlag();
        String moduleControlFlag = Objects.requireNonNull(CONTROL_FLAGS.get(controlFlag), "Control Flag not found");
        builder.append(SPACE);
        builder.append(moduleControlFlag);
        Map<String, ?> options = configurationEntry.getOptions();
        options.forEach((key, value) -> {
            builder.append(SPACE);
            builder.append((String)key);
            builder.append(EQUALS);
            if (value instanceof String) {
                builder.append(DOUBLE_QUOTE);
                builder.append(value);
                builder.append(DOUBLE_QUOTE);
            } else {
                builder.append(value);
            }
        });
        builder.append(SEMI_COLON);
        return builder.toString();
    }

    static {
        CONTROL_FLAGS.put(AppConfigurationEntry.LoginModuleControlFlag.OPTIONAL, "optional");
        CONTROL_FLAGS.put(AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, "required");
        CONTROL_FLAGS.put(AppConfigurationEntry.LoginModuleControlFlag.REQUISITE, "requisite");
        CONTROL_FLAGS.put(AppConfigurationEntry.LoginModuleControlFlag.SUFFICIENT, "sufficient");
    }
}

