/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.kafka.pubsub;

import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.apache.kafka.clients.consumer.ConsumerConfig;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.errors.WakeupException;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.nifi.annotation.behavior.DynamicProperty;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.behavior.WritesAttribute;
import org.apache.nifi.annotation.behavior.WritesAttributes;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.SeeAlso;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnStopped;
import org.apache.nifi.annotation.lifecycle.OnUnscheduled;
import org.apache.nifi.components.AllowableValue;
import org.apache.nifi.components.ConfigVerificationResult;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.components.Validator;
import org.apache.nifi.context.PropertyContext;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.kafka.shared.component.KafkaClientComponent;
import org.apache.nifi.kafka.shared.property.KeyEncoding;
import org.apache.nifi.kafka.shared.property.KeyFormat;
import org.apache.nifi.kafka.shared.property.OutputStrategy;
import org.apache.nifi.kafka.shared.property.provider.StandardKafkaPropertyProvider;
import org.apache.nifi.kafka.shared.validation.DynamicPropertyValidator;
import org.apache.nifi.kafka.shared.validation.KafkaClientCustomValidationFunction;
import org.apache.nifi.kafka.shared.validation.KafkaDeprecationValidator;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.processor.AbstractProcessor;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.VerifiableProcessor;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.processors.kafka.pubsub.ConsumeKafka_3;
import org.apache.nifi.processors.kafka.pubsub.ConsumerLease;
import org.apache.nifi.processors.kafka.pubsub.ConsumerPartitionsUtil;
import org.apache.nifi.processors.kafka.pubsub.ConsumerPool;
import org.apache.nifi.processors.kafka.pubsub.PublishKafkaRecord_3;
import org.apache.nifi.processors.kafka.pubsub.PublishKafka_3;
import org.apache.nifi.serialization.RecordReaderFactory;
import org.apache.nifi.serialization.RecordSetWriterFactory;

@CapabilityDescription(value="Consumes messages from Apache Kafka specifically built against the Kafka 3.0 Consumer API. The complementary NiFi processor for sending messages is PublishKafkaRecord_3. Please note that, at this time, the Processor assumes that all records that are retrieved from a given partition have the same schema. If any of the Kafka messages are pulled but cannot be parsed or written with the configured Record Reader or Record Writer, the contents of the message will be written to a separate FlowFile, and that FlowFile will be transferred to the 'parse.failure' relationship. Otherwise, each FlowFile is sent to the 'success' relationship and may contain many individual messages within the single FlowFile. A 'record.count' attribute is added to indicate how many messages are contained in the FlowFile. No two Kafka messages will be placed into the same FlowFile if they have different schemas, or if they have different values for a message header that is included by the <Headers to Add as Attributes> property.")
@Tags(value={"Kafka", "Get", "Record", "csv", "avro", "json", "Ingest", "Ingress", "Topic", "PubSub", "Consume", "3.0"})
@WritesAttributes(value={@WritesAttribute(attribute="record.count", description="The number of records received"), @WritesAttribute(attribute="mime.type", description="The MIME Type that is provided by the configured Record Writer"), @WritesAttribute(attribute="kafka.partition", description="The partition of the topic the records are from"), @WritesAttribute(attribute="kafka.timestamp", description="The timestamp of the message in the partition of the topic."), @WritesAttribute(attribute="kafka.topic", description="The topic records are from")})
@InputRequirement(value=InputRequirement.Requirement.INPUT_FORBIDDEN)
@DynamicProperty(name="The name of a Kafka configuration property.", value="The value of a given Kafka configuration property.", description="These properties will be added on the Kafka configuration after loading any provided configuration properties. In the event a dynamic property represents a property that was already set, its value will be ignored and WARN message logged. For the list of available Kafka properties please refer to: http://kafka.apache.org/documentation.html#configuration.", expressionLanguageScope=ExpressionLanguageScope.VARIABLE_REGISTRY)
@SeeAlso(value={ConsumeKafka_3.class, PublishKafka_3.class, PublishKafkaRecord_3.class})
public class ConsumeKafkaRecord_3
extends AbstractProcessor
implements KafkaClientComponent,
VerifiableProcessor {
    static final AllowableValue OFFSET_EARLIEST = new AllowableValue("earliest", "earliest", "Automatically reset the offset to the earliest offset");
    static final AllowableValue OFFSET_LATEST = new AllowableValue("latest", "latest", "Automatically reset the offset to the latest offset");
    static final AllowableValue OFFSET_NONE = new AllowableValue("none", "none", "Throw exception to the consumer if no previous offset is found for the consumer's group");
    static final AllowableValue TOPIC_NAME = new AllowableValue("names", "names", "Topic is a full topic name or comma separated list of names");
    static final AllowableValue TOPIC_PATTERN = new AllowableValue("pattern", "pattern", "Topic is a regex using the Java Pattern syntax");
    static final PropertyDescriptor TOPICS = new PropertyDescriptor.Builder().name("topic").displayName("Topic Name(s)").description("The name of the Kafka Topic(s) to pull from. More than one can be supplied if comma separated.").required(true).addValidator(StandardValidators.NON_BLANK_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).build();
    static final PropertyDescriptor TOPIC_TYPE = new PropertyDescriptor.Builder().name("topic_type").displayName("Topic Name Format").description("Specifies whether the Topic(s) provided are a comma separated list of names or a single regular expression").required(true).allowableValues(new AllowableValue[]{TOPIC_NAME, TOPIC_PATTERN}).defaultValue(TOPIC_NAME.getValue()).build();
    static final PropertyDescriptor RECORD_READER = new PropertyDescriptor.Builder().name("record-reader").displayName("Value Record Reader").description("The Record Reader to use for incoming FlowFiles").identifiesControllerService(RecordReaderFactory.class).expressionLanguageSupported(ExpressionLanguageScope.NONE).required(true).build();
    static final PropertyDescriptor RECORD_WRITER = new PropertyDescriptor.Builder().name("record-writer").displayName("Record Value Writer").description("The Record Writer to use in order to serialize the data before sending to Kafka").identifiesControllerService(RecordSetWriterFactory.class).expressionLanguageSupported(ExpressionLanguageScope.NONE).required(true).build();
    static final PropertyDescriptor GROUP_ID = new PropertyDescriptor.Builder().name("group.id").displayName("Group ID").description("A Group ID is used to identify consumers that are within the same consumer group. Corresponds to Kafka's 'group.id' property.").required(true).addValidator(StandardValidators.NON_BLANK_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).build();
    static final PropertyDescriptor AUTO_OFFSET_RESET = new PropertyDescriptor.Builder().name("auto.offset.reset").displayName("Offset Reset").description("Allows you to manage the condition when there is no initial offset in Kafka or if the current offset does not exist any more on the server (e.g. because that data has been deleted). Corresponds to Kafka's 'auto.offset.reset' property.").required(true).allowableValues(new AllowableValue[]{OFFSET_EARLIEST, OFFSET_LATEST, OFFSET_NONE}).defaultValue(OFFSET_LATEST.getValue()).build();
    static final PropertyDescriptor MAX_POLL_RECORDS = new PropertyDescriptor.Builder().name("max.poll.records").displayName("Max Poll Records").description("Specifies the maximum number of records Kafka should return in a single poll.").required(false).defaultValue("10000").addValidator(StandardValidators.POSITIVE_INTEGER_VALIDATOR).build();
    static final PropertyDescriptor COMMIT_OFFSETS = new PropertyDescriptor.Builder().name("Commit Offsets").displayName("Commit Offsets").description("Specifies whether or not this Processor should commit the offsets to Kafka after receiving messages. This value should be false when a PublishKafkaRecord processor is expected to commit the offsets using Exactly Once semantics, and should be reserved for dataflows that are designed to run within Stateless NiFi. See Processor's Usage / Additional Details for more information. Note that setting this value to false can lead to significant data duplication or potentially even data loss if the dataflow is not properly configured.").allowableValues(new String[]{"true", "false"}).defaultValue("true").build();
    static final PropertyDescriptor MAX_UNCOMMITTED_TIME = new PropertyDescriptor.Builder().name("max-uncommit-offset-wait").displayName("Max Uncommitted Time").description("Specifies the maximum amount of time allowed to pass before offsets must be committed. This value impacts how often offsets will be committed.  Committing offsets less often increases throughput but also increases the window of potential data duplication in the event of a rebalance or JVM restart between commits.  This value is also related to maximum poll records and the use of a message demarcator.  When using a message demarcator we can have far more uncommitted messages than when we're not as there is much less for us to keep track of in memory.").required(false).defaultValue("1 secs").addValidator(StandardValidators.TIME_PERIOD_VALIDATOR).dependsOn(COMMIT_OFFSETS, "true", new String[0]).build();
    static final PropertyDescriptor COMMS_TIMEOUT = new PropertyDescriptor.Builder().name("Communications Timeout").displayName("Communications Timeout").description("Specifies the timeout that the consumer should use when communicating with the Kafka Broker").required(true).defaultValue("60 secs").addValidator(StandardValidators.TIME_PERIOD_VALIDATOR).build();
    static final PropertyDescriptor HONOR_TRANSACTIONS = new PropertyDescriptor.Builder().name("honor-transactions").displayName("Honor Transactions").description("Specifies whether or not NiFi should honor transactional guarantees when communicating with Kafka. If false, the Processor will use an \"isolation level\" of read_uncomitted. This means that messages will be received as soon as they are written to Kafka but will be pulled, even if the producer cancels the transactions. If this value is true, NiFi will not receive any messages for which the producer's transaction was canceled, but this can result in some latency since the consumer must wait for the producer to finish its entire transaction instead of pulling as the messages become available.").expressionLanguageSupported(ExpressionLanguageScope.NONE).allowableValues(new String[]{"true", "false"}).defaultValue("true").required(true).build();
    static final PropertyDescriptor MESSAGE_HEADER_ENCODING = new PropertyDescriptor.Builder().name("message-header-encoding").displayName("Message Header Encoding").description("Any message header that is found on a Kafka message will be added to the outbound FlowFile as an attribute. This property indicates the Character Encoding to use for deserializing the headers.").addValidator(StandardValidators.CHARACTER_SET_VALIDATOR).defaultValue("UTF-8").required(false).build();
    static final PropertyDescriptor OUTPUT_STRATEGY = new PropertyDescriptor.Builder().name("output-strategy").displayName("Output Strategy").description("The format used to output the Kafka record into a FlowFile record.").required(true).defaultValue(OutputStrategy.USE_VALUE.getValue()).allowableValues(OutputStrategy.class).build();
    static final PropertyDescriptor KEY_FORMAT = new PropertyDescriptor.Builder().name("key-format").displayName("Key Format").description("Specifies how to represent the Kafka Record's Key in the output").required(true).defaultValue(KeyFormat.BYTE_ARRAY.getValue()).allowableValues(KeyFormat.class).dependsOn(OUTPUT_STRATEGY, OutputStrategy.USE_WRAPPER.getValue(), new String[0]).build();
    static final PropertyDescriptor KEY_RECORD_READER = new PropertyDescriptor.Builder().name("key-record-reader").displayName("Key Record Reader").description("The Record Reader to use for parsing the Kafka Record's key into a Record").identifiesControllerService(RecordReaderFactory.class).expressionLanguageSupported(ExpressionLanguageScope.NONE).dependsOn(KEY_FORMAT, KeyFormat.RECORD.getValue(), new String[0]).build();
    static final PropertyDescriptor HEADER_NAME_REGEX = new PropertyDescriptor.Builder().name("header-name-regex").displayName("Headers to Add as Attributes (Regex)").description("A Regular Expression that is matched against all message headers. Any message header whose name matches the regex will be added to the FlowFile as an Attribute. If not specified, no Header values will be added as FlowFile attributes. If two messages have a different value for the same header and that header is selected by the provided regex, then those two messages must be added to different FlowFiles. As a result, users should be cautious about using a regex like \".*\" if messages are expected to have header values that are unique per message, such as an identifier or timestamp, because it will prevent NiFi from bundling the messages together efficiently.").addValidator(StandardValidators.REGULAR_EXPRESSION_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.NONE).required(false).dependsOn(OUTPUT_STRATEGY, OutputStrategy.USE_VALUE.getValue(), new String[0]).build();
    static final PropertyDescriptor SEPARATE_BY_KEY = new PropertyDescriptor.Builder().name("separate-by-key").displayName("Separate By Key").description("If true, two Records will only be added to the same FlowFile if both of the Kafka Messages have identical keys.").required(false).allowableValues(new String[]{"true", "false"}).defaultValue("false").build();
    static final PropertyDescriptor KEY_ATTRIBUTE_ENCODING = new PropertyDescriptor.Builder().name("key-attribute-encoding").displayName("Key Attribute Encoding").description("If the <Separate By Key> property is set to true, FlowFiles that are emitted have an attribute named 'kafka.key'. This property dictates how the value of the attribute should be encoded.").required(true).defaultValue(KeyEncoding.UTF8.getValue()).allowableValues(KeyEncoding.class).dependsOn(OUTPUT_STRATEGY, OutputStrategy.USE_VALUE.getValue(), new String[0]).build();
    static final Relationship REL_SUCCESS = new Relationship.Builder().name("success").description("FlowFiles received from Kafka.  Depending on demarcation strategy it is a flow file per message or a bundle of messages grouped by topic and partition.").build();
    static final Relationship REL_PARSE_FAILURE = new Relationship.Builder().name("parse.failure").description("If a message from Kafka cannot be parsed using the configured Record Reader, the contents of the message will be routed to this Relationship as its own individual FlowFile.").build();
    static final List<PropertyDescriptor> DESCRIPTORS;
    static final Set<Relationship> RELATIONSHIPS;
    private volatile ConsumerPool consumerPool = null;
    private final Set<ConsumerLease> activeLeases = Collections.synchronizedSet(new HashSet());

    public Set<Relationship> getRelationships() {
        return RELATIONSHIPS;
    }

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return DESCRIPTORS;
    }

    @OnStopped
    public void close() {
        ConsumerPool pool = this.consumerPool;
        this.consumerPool = null;
        if (pool != null) {
            pool.close();
        }
    }

    protected PropertyDescriptor getSupportedDynamicPropertyDescriptor(String propertyDescriptorName) {
        return new PropertyDescriptor.Builder().description("Specifies the value for '" + propertyDescriptorName + "' Kafka Configuration.").name(propertyDescriptorName).addValidator((Validator)new DynamicPropertyValidator(ConsumerConfig.class)).dynamic(true).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).build();
    }

    protected Collection<ValidationResult> customValidate(ValidationContext validationContext) {
        KafkaDeprecationValidator.validate(((Object)((Object)this)).getClass(), (String)this.getIdentifier(), (ValidationContext)validationContext);
        KafkaClientCustomValidationFunction validationFunction = new KafkaClientCustomValidationFunction();
        Collection validationResults = validationFunction.apply(validationContext);
        ValidationResult consumerPartitionsResult = ConsumerPartitionsUtil.validateConsumePartitions(validationContext.getAllProperties());
        validationResults.add(consumerPartitionsResult);
        boolean explicitPartitionMapping = ConsumerPartitionsUtil.isPartitionAssignmentExplicit(validationContext.getAllProperties());
        if (explicitPartitionMapping) {
            String topicType = validationContext.getProperty(TOPIC_TYPE).getValue();
            if (TOPIC_PATTERN.getValue().equals(topicType)) {
                validationResults.add(new ValidationResult.Builder().subject(TOPIC_TYPE.getDisplayName()).input(TOPIC_PATTERN.getDisplayName()).valid(false).explanation("It is not valid to explicitly assign topic partitions and also using a Topic Pattern. Topic Partitions may be assigned only if explicitly specifying topic names also.").build());
            }
        }
        return validationResults;
    }

    private synchronized ConsumerPool getConsumerPool(ProcessContext context) {
        ConsumerPool pool = this.consumerPool;
        if (pool != null) {
            return pool;
        }
        ConsumerPool consumerPool = this.createConsumerPool(context, this.getLogger());
        boolean explicitAssignment = ConsumerPartitionsUtil.isPartitionAssignmentExplicit(context.getAllProperties());
        if (explicitAssignment) {
            int numAssignedPartitions = ConsumerPartitionsUtil.getPartitionAssignmentCount(context.getAllProperties());
            int partitionCount = consumerPool.getPartitionCount();
            if (partitionCount != numAssignedPartitions) {
                context.yield();
                consumerPool.close();
                throw new ProcessException("Illegal Partition Assignment: There are " + numAssignedPartitions + " partitions statically assigned using the partitions.* property names, but the Kafka topic(s) have " + partitionCount + " partitions");
            }
        }
        this.consumerPool = consumerPool;
        return consumerPool;
    }

    protected ConsumerPool createConsumerPool(ProcessContext context, ComponentLog log) {
        int[] partitionsToConsume;
        int maxLeases = context.getMaxConcurrentTasks();
        Long maxUncommittedTime = context.getProperty(MAX_UNCOMMITTED_TIME).asTimePeriod(TimeUnit.MILLISECONDS);
        boolean commitOffsets = context.getProperty(COMMIT_OFFSETS).asBoolean();
        StandardKafkaPropertyProvider propertyProvider = new StandardKafkaPropertyProvider(ConsumerConfig.class);
        Map props = propertyProvider.getProperties((PropertyContext)context);
        props.put("enable.auto.commit", "false");
        props.put("key.deserializer", ByteArrayDeserializer.class.getName());
        props.put("value.deserializer", ByteArrayDeserializer.class.getName());
        String topicListing = context.getProperty(TOPICS).evaluateAttributeExpressions().getValue();
        String topicType = context.getProperty(TOPIC_TYPE).evaluateAttributeExpressions().getValue();
        ArrayList<String> topics = new ArrayList<String>();
        String securityProtocol = context.getProperty(SECURITY_PROTOCOL).getValue();
        String bootstrapServers = context.getProperty(BOOTSTRAP_SERVERS).evaluateAttributeExpressions().getValue();
        RecordReaderFactory readerFactory = (RecordReaderFactory)context.getProperty(RECORD_READER).asControllerService(RecordReaderFactory.class);
        RecordSetWriterFactory writerFactory = (RecordSetWriterFactory)context.getProperty(RECORD_WRITER).asControllerService(RecordSetWriterFactory.class);
        boolean honorTransactions = context.getProperty(HONOR_TRANSACTIONS).asBoolean();
        int commsTimeoutMillis = context.getProperty(COMMS_TIMEOUT).asTimePeriod(TimeUnit.MILLISECONDS).intValue();
        props.put("default.api.timeout.ms", commsTimeoutMillis);
        String charsetName = context.getProperty(MESSAGE_HEADER_ENCODING).evaluateAttributeExpressions().getValue();
        Charset charset = Charset.forName(charsetName);
        OutputStrategy outputStrategy = OutputStrategy.valueOf((String)context.getProperty(OUTPUT_STRATEGY).getValue());
        String keyFormat = context.getProperty(KEY_FORMAT).getValue();
        RecordReaderFactory keyReaderFactory = (RecordReaderFactory)context.getProperty(KEY_RECORD_READER).asControllerService(RecordReaderFactory.class);
        String headerNameRegex = context.getProperty(HEADER_NAME_REGEX).getValue();
        boolean isActiveHeaderNamePattern = OutputStrategy.USE_VALUE.equals((Object)outputStrategy) && headerNameRegex != null;
        Pattern headerNamePattern = isActiveHeaderNamePattern ? Pattern.compile(headerNameRegex) : null;
        boolean separateByKey = context.getProperty(SEPARATE_BY_KEY).asBoolean();
        String keyEncoding = context.getProperty(KEY_ATTRIBUTE_ENCODING).getValue();
        try {
            partitionsToConsume = ConsumerPartitionsUtil.getPartitionsForHost(context.getAllProperties(), this.getLogger());
        }
        catch (UnknownHostException uhe) {
            throw new ProcessException("Could not determine localhost's hostname", (Throwable)uhe);
        }
        if (topicType.equals(TOPIC_NAME.getValue())) {
            for (String topic : topicListing.split(",")) {
                String trimmedName = topic.trim();
                if (trimmedName.isEmpty()) continue;
                topics.add(trimmedName);
            }
            return new ConsumerPool(maxLeases, readerFactory, writerFactory, (Map<String, Object>)props, topics, maxUncommittedTime, securityProtocol, bootstrapServers, log, honorTransactions, charset, headerNamePattern, separateByKey, keyEncoding, partitionsToConsume, commitOffsets, outputStrategy, keyFormat, keyReaderFactory);
        }
        if (topicType.equals(TOPIC_PATTERN.getValue())) {
            Pattern topicPattern = Pattern.compile(topicListing.trim());
            return new ConsumerPool(maxLeases, readerFactory, writerFactory, (Map<String, Object>)props, topicPattern, maxUncommittedTime, securityProtocol, bootstrapServers, log, honorTransactions, charset, headerNamePattern, separateByKey, keyEncoding, partitionsToConsume, commitOffsets, outputStrategy, keyFormat, keyReaderFactory);
        }
        this.getLogger().error("Subscription type has an unknown value {}", new Object[]{topicType});
        return null;
    }

    @OnUnscheduled
    public void interruptActiveThreads() {
        long nanosToWait = TimeUnit.SECONDS.toNanos(5L);
        long start = System.nanoTime();
        while (System.nanoTime() - start < nanosToWait && !this.activeLeases.isEmpty()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
                return;
            }
        }
        if (!this.activeLeases.isEmpty()) {
            int count = 0;
            for (ConsumerLease lease : this.activeLeases) {
                this.getLogger().info("Consumer {} has not finished after waiting 30 seconds; will attempt to wake-up the lease", new Object[]{lease});
                lease.wakeup();
                ++count;
            }
            this.getLogger().info("Woke up {} consumers", new Object[]{count});
        }
        this.activeLeases.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void onTrigger(ProcessContext context, ProcessSession session) throws ProcessException {
        ConsumerPool pool = this.getConsumerPool(context);
        if (pool == null) {
            context.yield();
            return;
        }
        try (ConsumerLease lease = pool.obtainConsumer(session, context);){
            if (lease == null) {
                context.yield();
                return;
            }
            this.activeLeases.add(lease);
            try {
                while (this.isScheduled() && lease.continuePolling()) {
                    lease.poll();
                }
                if (!lease.commit()) {
                    context.yield();
                }
            }
            catch (WakeupException we) {
                this.getLogger().warn("Was interrupted while trying to communicate with Kafka with lease {}. Will roll back session and discard any partially received data.", new Object[]{lease});
            }
            catch (KafkaException kex) {
                this.getLogger().error("Exception while interacting with Kafka so will close the lease {}", new Object[]{lease, kex});
                context.yield();
            }
            catch (Throwable t) {
                this.getLogger().error("Exception while processing data from kafka so will close the lease {}", new Object[]{lease, t});
                context.yield();
                this.activeLeases.remove(lease);
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                this.activeLeases.remove(lease);
            }
        }
    }

    public List<ConfigVerificationResult> verify(ProcessContext context, ComponentLog verificationLogger, Map<String, String> attributes) {
        try (ConsumerPool consumerPool = this.createConsumerPool(context, verificationLogger);){
            List<ConfigVerificationResult> list = consumerPool.verifyConfiguration();
            return list;
        }
    }

    static {
        ArrayList<PropertyDescriptor> descriptors = new ArrayList<PropertyDescriptor>();
        descriptors.add(BOOTSTRAP_SERVERS);
        descriptors.add(TOPICS);
        descriptors.add(TOPIC_TYPE);
        descriptors.add(RECORD_READER);
        descriptors.add(RECORD_WRITER);
        descriptors.add(GROUP_ID);
        descriptors.add(OUTPUT_STRATEGY);
        descriptors.add(HEADER_NAME_REGEX);
        descriptors.add(KEY_ATTRIBUTE_ENCODING);
        descriptors.add(KEY_FORMAT);
        descriptors.add(KEY_RECORD_READER);
        descriptors.add(COMMIT_OFFSETS);
        descriptors.add(MAX_UNCOMMITTED_TIME);
        descriptors.add(HONOR_TRANSACTIONS);
        descriptors.add(SECURITY_PROTOCOL);
        descriptors.add(SASL_MECHANISM);
        descriptors.add(KERBEROS_CREDENTIALS_SERVICE);
        descriptors.add(SELF_CONTAINED_KERBEROS_USER_SERVICE);
        descriptors.add(KERBEROS_SERVICE_NAME);
        descriptors.add(KERBEROS_PRINCIPAL);
        descriptors.add(KERBEROS_KEYTAB);
        descriptors.add(SASL_USERNAME);
        descriptors.add(SASL_PASSWORD);
        descriptors.add(TOKEN_AUTHENTICATION);
        descriptors.add(AWS_PROFILE_NAME);
        descriptors.add(SSL_CONTEXT_SERVICE);
        descriptors.add(SEPARATE_BY_KEY);
        descriptors.add(AUTO_OFFSET_RESET);
        descriptors.add(MESSAGE_HEADER_ENCODING);
        descriptors.add(MAX_POLL_RECORDS);
        descriptors.add(COMMS_TIMEOUT);
        DESCRIPTORS = Collections.unmodifiableList(descriptors);
        HashSet<Relationship> rels = new HashSet<Relationship>();
        rels.add(REL_SUCCESS);
        rels.add(REL_PARSE_FAILURE);
        RELATIONSHIPS = Collections.unmodifiableSet(rels);
    }
}

