/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.kafka.pubsub;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.logging.ComponentLog;

public class ConsumerPartitionsUtil {
    public static final String PARTITION_PROPERTY_NAME_PREFIX = "partitions.";

    public static int[] getPartitionsForHost(Map<String, String> properties, ComponentLog logger) throws UnknownHostException {
        Map<String, String> hostnameToPartitionString = ConsumerPartitionsUtil.mapHostnamesToPartitionStrings(properties);
        Map<String, int[]> partitionsByHost = ConsumerPartitionsUtil.mapPartitionValueToIntArrays(hostnameToPartitionString);
        if (partitionsByHost.isEmpty()) {
            logger.debug("No explicit Consumer Partitions have been declared.");
            return null;
        }
        logger.info("Found the following mapping of hosts to partitions: {}", new Object[]{hostnameToPartitionString});
        int[] partitionsForThisHost = ConsumerPartitionsUtil.getPartitionsForThisHost(partitionsByHost);
        if (partitionsForThisHost == null) {
            throw new IllegalArgumentException("Could not find a partition mapping for host " + InetAddress.getLocalHost().getCanonicalHostName());
        }
        return partitionsForThisHost;
    }

    private static Map<String, int[]> mapPartitionValueToIntArrays(Map<String, String> partitionValues) {
        HashMap<String, int[]> partitionsByHost = new HashMap<String, int[]>();
        for (Map.Entry<String, String> entry : partitionValues.entrySet()) {
            String host = entry.getKey();
            int[] partitions = ConsumerPartitionsUtil.parsePartitions(host, entry.getValue());
            partitionsByHost.put(host, partitions);
        }
        return partitionsByHost;
    }

    private static int[] getPartitionsForThisHost(Map<String, int[]> partitionsByHost) throws UnknownHostException {
        InetAddress localhost = InetAddress.getLocalHost();
        int[] partitionsForThisHost = partitionsByHost.get(localhost.getCanonicalHostName());
        if (partitionsForThisHost != null) {
            return partitionsForThisHost;
        }
        partitionsForThisHost = partitionsByHost.get(localhost.getHostName());
        if (partitionsForThisHost != null) {
            return partitionsForThisHost;
        }
        return partitionsByHost.get(localhost.getHostAddress());
    }

    private static Map<String, String> mapHostnamesToPartitionStrings(Map<String, String> properties) {
        HashMap<String, String> hostnameToPartitionString = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            String propertyName = entry.getKey();
            if (!propertyName.startsWith(PARTITION_PROPERTY_NAME_PREFIX) || propertyName.length() <= PARTITION_PROPERTY_NAME_PREFIX.length()) continue;
            String propertyNameAfterPrefix = propertyName.substring(PARTITION_PROPERTY_NAME_PREFIX.length());
            hostnameToPartitionString.put(propertyNameAfterPrefix, entry.getValue());
        }
        return hostnameToPartitionString;
    }

    private static int[] parsePartitions(String hostname, String propertyValue) {
        String[] splits = propertyValue.split(",");
        ArrayList<Integer> partitionList = new ArrayList<Integer>();
        for (String split : splits) {
            if (split.trim().isEmpty()) continue;
            try {
                int partition = Integer.parseInt(split.trim());
                if (partition < 0) {
                    throw new IllegalArgumentException("Found invalid value for the partitions for hostname " + hostname + ": " + split + " is negative");
                }
                partitionList.add(partition);
            }
            catch (NumberFormatException nfe) {
                throw new IllegalArgumentException("Found invalid value for the partitions for hostname " + hostname + ": " + split + " is not an integer");
            }
        }
        return partitionList.stream().mapToInt(Integer::intValue).toArray();
    }

    public static ValidationResult validateConsumePartitions(Map<String, String> properties) {
        int[] partitionsForThisHost;
        Map<String, String> hostnameToPartitionMapping = ConsumerPartitionsUtil.mapHostnamesToPartitionStrings(properties);
        if (hostnameToPartitionMapping.isEmpty()) {
            return new ValidationResult.Builder().valid(true).build();
        }
        HashSet<Integer> partitionsClaimed = new HashSet<Integer>();
        HashSet<Integer> duplicatePartitions = new HashSet<Integer>();
        for (Map.Entry<String, String> entry : hostnameToPartitionMapping.entrySet()) {
            int[] partitions;
            for (int partition : partitions = ConsumerPartitionsUtil.parsePartitions(entry.getKey(), entry.getValue())) {
                boolean added = partitionsClaimed.add(partition);
                if (added) continue;
                duplicatePartitions.add(partition);
            }
        }
        ArrayList<Integer> partitionsMissing = new ArrayList<Integer>();
        for (int i = 0; i < partitionsClaimed.size(); ++i) {
            if (partitionsClaimed.contains(i)) continue;
            partitionsMissing.add(i);
        }
        if (!partitionsMissing.isEmpty()) {
            return new ValidationResult.Builder().subject("Partitions").input(((Object)partitionsClaimed).toString()).valid(false).explanation("The following partitions were not mapped to any node: " + ((Object)partitionsMissing).toString()).build();
        }
        if (!duplicatePartitions.isEmpty()) {
            return new ValidationResult.Builder().subject("Partitions").input(((Object)partitionsClaimed).toString()).valid(false).explanation("The following partitions were mapped to multiple nodes: " + ((Object)duplicatePartitions).toString()).build();
        }
        Map<String, int[]> partitionsByHost = ConsumerPartitionsUtil.mapPartitionValueToIntArrays(hostnameToPartitionMapping);
        try {
            partitionsForThisHost = ConsumerPartitionsUtil.getPartitionsForThisHost(partitionsByHost);
        }
        catch (UnknownHostException e) {
            return new ValidationResult.Builder().valid(false).subject("Partition Assignment").explanation("Unable to determine hostname of localhost").build();
        }
        if (partitionsForThisHost == null) {
            return new ValidationResult.Builder().subject("Partition Assignment").valid(false).explanation("No assignment was given for this host").build();
        }
        return new ValidationResult.Builder().valid(true).build();
    }

    public static boolean isPartitionAssignmentExplicit(Map<String, String> properties) {
        Map<String, String> hostnameToPartitionMapping = ConsumerPartitionsUtil.mapHostnamesToPartitionStrings(properties);
        return !hostnameToPartitionMapping.isEmpty();
    }

    public static int getPartitionAssignmentCount(Map<String, String> properties) {
        Map<String, String> hostnameToPartitionMapping = ConsumerPartitionsUtil.mapHostnamesToPartitionStrings(properties);
        Map<String, int[]> partitions = ConsumerPartitionsUtil.mapPartitionValueToIntArrays(hostnameToPartitionMapping);
        int count = 0;
        for (int[] partitionArray : partitions.values()) {
            count += partitionArray.length;
        }
        return count;
    }
}

