/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.kafka.pubsub;

import java.io.Closeable;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Pattern;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRebalanceListener;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.common.TopicPartition;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processors.kafka.pubsub.ConsumerLease;
import org.apache.nifi.serialization.RecordReaderFactory;
import org.apache.nifi.serialization.RecordSetWriterFactory;

public class ConsumerPool
implements Closeable {
    private final BlockingQueue<SimpleConsumerLease> pooledLeases;
    private final List<String> topics;
    private final Pattern topicPattern;
    private final Map<String, Object> kafkaProperties;
    private final long maxWaitMillis;
    private final ComponentLog logger;
    private final byte[] demarcatorBytes;
    private final String keyEncoding;
    private final String securityProtocol;
    private final String bootstrapServers;
    private final boolean honorTransactions;
    private final RecordReaderFactory readerFactory;
    private final RecordSetWriterFactory writerFactory;
    private final Charset headerCharacterSet;
    private final Pattern headerNamePattern;
    private final boolean separateByKey;
    private final int[] partitionsToConsume;
    private final AtomicLong consumerCreatedCountRef = new AtomicLong();
    private final AtomicLong consumerClosedCountRef = new AtomicLong();
    private final AtomicLong leasesObtainedCountRef = new AtomicLong();
    private final Queue<List<TopicPartition>> availableTopicPartitions = new LinkedBlockingQueue<List<TopicPartition>>();

    public ConsumerPool(int maxConcurrentLeases, byte[] demarcator, boolean separateByKey, Map<String, Object> kafkaProperties, List<String> topics, long maxWaitMillis, String keyEncoding, String securityProtocol, String bootstrapServers, ComponentLog logger, boolean honorTransactions, Charset headerCharacterSet, Pattern headerNamePattern, int[] partitionsToConsume) {
        this.pooledLeases = new LinkedBlockingQueue<SimpleConsumerLease>();
        this.maxWaitMillis = maxWaitMillis;
        this.logger = logger;
        this.demarcatorBytes = demarcator;
        this.keyEncoding = keyEncoding;
        this.securityProtocol = securityProtocol;
        this.bootstrapServers = bootstrapServers;
        this.kafkaProperties = Collections.unmodifiableMap(kafkaProperties);
        this.topics = Collections.unmodifiableList(topics);
        this.topicPattern = null;
        this.readerFactory = null;
        this.writerFactory = null;
        this.honorTransactions = honorTransactions;
        this.headerCharacterSet = headerCharacterSet;
        this.headerNamePattern = headerNamePattern;
        this.separateByKey = separateByKey;
        this.partitionsToConsume = partitionsToConsume;
        this.enqueueAssignedPartitions(partitionsToConsume);
    }

    public ConsumerPool(int maxConcurrentLeases, byte[] demarcator, boolean separateByKey, Map<String, Object> kafkaProperties, Pattern topics, long maxWaitMillis, String keyEncoding, String securityProtocol, String bootstrapServers, ComponentLog logger, boolean honorTransactions, Charset headerCharacterSet, Pattern headerNamePattern, int[] partitionsToConsume) {
        this.pooledLeases = new LinkedBlockingQueue<SimpleConsumerLease>();
        this.maxWaitMillis = maxWaitMillis;
        this.logger = logger;
        this.demarcatorBytes = demarcator;
        this.keyEncoding = keyEncoding;
        this.securityProtocol = securityProtocol;
        this.bootstrapServers = bootstrapServers;
        this.kafkaProperties = Collections.unmodifiableMap(kafkaProperties);
        this.topics = null;
        this.topicPattern = topics;
        this.readerFactory = null;
        this.writerFactory = null;
        this.honorTransactions = honorTransactions;
        this.headerCharacterSet = headerCharacterSet;
        this.headerNamePattern = headerNamePattern;
        this.separateByKey = separateByKey;
        this.partitionsToConsume = partitionsToConsume;
        this.enqueueAssignedPartitions(partitionsToConsume);
    }

    public ConsumerPool(int maxConcurrentLeases, RecordReaderFactory readerFactory, RecordSetWriterFactory writerFactory, Map<String, Object> kafkaProperties, Pattern topics, long maxWaitMillis, String securityProtocol, String bootstrapServers, ComponentLog logger, boolean honorTransactions, Charset headerCharacterSet, Pattern headerNamePattern, boolean separateByKey, String keyEncoding, int[] partitionsToConsume) {
        this.pooledLeases = new LinkedBlockingQueue<SimpleConsumerLease>();
        this.maxWaitMillis = maxWaitMillis;
        this.logger = logger;
        this.demarcatorBytes = null;
        this.readerFactory = readerFactory;
        this.writerFactory = writerFactory;
        this.securityProtocol = securityProtocol;
        this.bootstrapServers = bootstrapServers;
        this.kafkaProperties = Collections.unmodifiableMap(kafkaProperties);
        this.topics = null;
        this.topicPattern = topics;
        this.honorTransactions = honorTransactions;
        this.headerCharacterSet = headerCharacterSet;
        this.headerNamePattern = headerNamePattern;
        this.separateByKey = separateByKey;
        this.keyEncoding = keyEncoding;
        this.partitionsToConsume = partitionsToConsume;
        this.enqueueAssignedPartitions(partitionsToConsume);
    }

    public ConsumerPool(int maxConcurrentLeases, RecordReaderFactory readerFactory, RecordSetWriterFactory writerFactory, Map<String, Object> kafkaProperties, List<String> topics, long maxWaitMillis, String securityProtocol, String bootstrapServers, ComponentLog logger, boolean honorTransactions, Charset headerCharacterSet, Pattern headerNamePattern, boolean separateByKey, String keyEncoding, int[] partitionsToConsume) {
        this.pooledLeases = new LinkedBlockingQueue<SimpleConsumerLease>();
        this.maxWaitMillis = maxWaitMillis;
        this.logger = logger;
        this.demarcatorBytes = null;
        this.readerFactory = readerFactory;
        this.writerFactory = writerFactory;
        this.securityProtocol = securityProtocol;
        this.bootstrapServers = bootstrapServers;
        this.kafkaProperties = Collections.unmodifiableMap(kafkaProperties);
        this.topics = topics;
        this.topicPattern = null;
        this.honorTransactions = honorTransactions;
        this.headerCharacterSet = headerCharacterSet;
        this.headerNamePattern = headerNamePattern;
        this.separateByKey = separateByKey;
        this.keyEncoding = keyEncoding;
        this.partitionsToConsume = partitionsToConsume;
        this.enqueueAssignedPartitions(partitionsToConsume);
    }

    public int getPartitionCount() {
        if (this.topics == null || this.topics.isEmpty()) {
            return -1;
        }
        int partitionsEachTopic = 0;
        try (Consumer<byte[], byte[]> consumer = this.createKafkaConsumer();){
            for (String topicName : this.topics) {
                List partitionInfos = consumer.partitionsFor(topicName);
                int partitionsThisTopic = partitionInfos.size();
                if (partitionsEachTopic != 0 && partitionsThisTopic != partitionsEachTopic) {
                    throw new IllegalStateException("The specific topic names do not have the same number of partitions");
                }
                partitionsEachTopic = partitionsThisTopic;
            }
        }
        return partitionsEachTopic;
    }

    public ConsumerLease obtainConsumer(ProcessSession session, ProcessContext processContext) {
        this.recreateAssignedConsumers();
        SimpleConsumerLease lease = (SimpleConsumerLease)this.pooledLeases.poll();
        if (lease == null && (lease = this.createConsumerLease()) == null) {
            return null;
        }
        lease.setProcessSession(session, processContext);
        this.leasesObtainedCountRef.incrementAndGet();
        return lease;
    }

    private void recreateAssignedConsumers() {
        List<TopicPartition> topicPartitions;
        while ((topicPartitions = this.availableTopicPartitions.poll()) != null) {
            SimpleConsumerLease simpleConsumerLease = this.createConsumerLease(topicPartitions);
            this.pooledLeases.add(simpleConsumerLease);
        }
    }

    private SimpleConsumerLease createConsumerLease() {
        if (this.partitionsToConsume != null) {
            this.logger.debug("Cannot obtain lease to communicate with Kafka. Since partitions are explicitly assigned, cannot create a new lease.");
            return null;
        }
        Consumer<byte[], byte[]> consumer = this.createKafkaConsumer();
        this.consumerCreatedCountRef.incrementAndGet();
        SimpleConsumerLease lease = new SimpleConsumerLease(consumer, null);
        if (this.topics == null) {
            consumer.subscribe(this.topicPattern, (ConsumerRebalanceListener)lease);
        } else {
            consumer.subscribe(this.topics, (ConsumerRebalanceListener)lease);
        }
        return lease;
    }

    private SimpleConsumerLease createConsumerLease(List<TopicPartition> topicPartitions) {
        Consumer<byte[], byte[]> consumer = this.createKafkaConsumer();
        this.consumerCreatedCountRef.incrementAndGet();
        consumer.assign(topicPartitions);
        SimpleConsumerLease lease = new SimpleConsumerLease(consumer, topicPartitions);
        return lease;
    }

    private void enqueueAssignedPartitions(int[] partitionsToConsume) {
        if (partitionsToConsume == null) {
            return;
        }
        for (int partition : partitionsToConsume) {
            List<TopicPartition> topicPartitions = this.createTopicPartitions(partition);
            this.availableTopicPartitions.offer(topicPartitions);
        }
    }

    private List<TopicPartition> createTopicPartitions(int partition) {
        ArrayList<TopicPartition> topicPartitions = new ArrayList<TopicPartition>();
        for (String topic : this.topics) {
            TopicPartition topicPartition = new TopicPartition(topic, partition);
            topicPartitions.add(topicPartition);
        }
        return topicPartitions;
    }

    protected Consumer<byte[], byte[]> createKafkaConsumer() {
        HashMap<String, Object> properties = new HashMap<String, Object>(this.kafkaProperties);
        if (this.honorTransactions) {
            properties.put("isolation.level", "read_committed");
        } else {
            properties.put("isolation.level", "read_uncommitted");
        }
        KafkaConsumer consumer = new KafkaConsumer(properties);
        return consumer;
    }

    @Override
    public void close() {
        ArrayList leases = new ArrayList();
        this.pooledLeases.drainTo(leases);
        leases.forEach(lease -> lease.close(true));
    }

    private void closeConsumer(Consumer<?, ?> consumer) {
        this.consumerClosedCountRef.incrementAndGet();
        try {
            consumer.unsubscribe();
        }
        catch (Exception e) {
            this.logger.warn("Failed while unsubscribing " + consumer, (Throwable)e);
        }
        try {
            consumer.close();
        }
        catch (Exception e) {
            this.logger.warn("Failed while closing " + consumer, (Throwable)e);
        }
    }

    PoolStats getPoolStats() {
        return new PoolStats(this.consumerCreatedCountRef.get(), this.consumerClosedCountRef.get(), this.leasesObtainedCountRef.get());
    }

    static final class PoolStats {
        final long consumerCreatedCount;
        final long consumerClosedCount;
        final long leasesObtainedCount;

        PoolStats(long consumerCreatedCount, long consumerClosedCount, long leasesObtainedCount) {
            this.consumerCreatedCount = consumerCreatedCount;
            this.consumerClosedCount = consumerClosedCount;
            this.leasesObtainedCount = leasesObtainedCount;
        }

        public String toString() {
            return "Created Consumers [" + this.consumerCreatedCount + "]\nClosed Consumers  [" + this.consumerClosedCount + "]\nLeases Obtained   [" + this.leasesObtainedCount + "]\n";
        }
    }

    private class SimpleConsumerLease
    extends ConsumerLease {
        private final Consumer<byte[], byte[]> consumer;
        private final List<TopicPartition> assignedPartitions;
        private volatile ProcessSession session;
        private volatile ProcessContext processContext;
        private volatile boolean closedConsumer;

        private SimpleConsumerLease(Consumer<byte[], byte[]> consumer, List<TopicPartition> assignedPartitions) {
            super(ConsumerPool.this.maxWaitMillis, consumer, ConsumerPool.this.demarcatorBytes, ConsumerPool.this.keyEncoding, ConsumerPool.this.securityProtocol, ConsumerPool.this.bootstrapServers, ConsumerPool.this.readerFactory, ConsumerPool.this.writerFactory, ConsumerPool.this.logger, ConsumerPool.this.headerCharacterSet, ConsumerPool.this.headerNamePattern, ConsumerPool.this.separateByKey);
            this.consumer = consumer;
            this.assignedPartitions = assignedPartitions;
        }

        void setProcessSession(ProcessSession session, ProcessContext context) {
            this.session = session;
            this.processContext = context;
        }

        @Override
        public List<TopicPartition> getAssignedPartitions() {
            return this.assignedPartitions;
        }

        @Override
        public void yield() {
            if (this.processContext != null) {
                this.processContext.yield();
            }
        }

        @Override
        public ProcessSession getProcessSession() {
            return this.session;
        }

        @Override
        public void close() {
            super.close();
            this.close(false);
        }

        public void close(boolean forceClose) {
            if (this.closedConsumer) {
                return;
            }
            super.close();
            if (this.session != null) {
                this.session.rollback();
                this.setProcessSession(null, null);
            }
            if (forceClose || this.isPoisoned() || !ConsumerPool.this.pooledLeases.offer(this)) {
                this.closedConsumer = true;
                ConsumerPool.this.closeConsumer(this.consumer);
                if (this.assignedPartitions != null) {
                    ConsumerPool.this.logger.debug("Adding partitions {} back to the pool", new Object[]{this.assignedPartitions});
                    ConsumerPool.this.availableTopicPartitions.offer(this.assignedPartitions);
                }
            }
        }
    }
}

