/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.jms.cf;

import jakarta.jms.ConnectionFactory;
import org.apache.nifi.jms.cf.JMSConnectionFactoryHandlerDefinition;
import org.apache.nifi.logging.ComponentLog;

public abstract class CachedJMSConnectionFactoryHandler
implements JMSConnectionFactoryHandlerDefinition {
    private final ComponentLog logger;
    private volatile ConnectionFactory connectionFactory;

    protected CachedJMSConnectionFactoryHandler(ComponentLog logger) {
        this.logger = logger;
    }

    public abstract ConnectionFactory createConnectionFactory();

    @Override
    public synchronized ConnectionFactory getConnectionFactory() {
        if (this.connectionFactory == null) {
            this.connectionFactory = this.createConnectionFactory();
        } else {
            this.logger.debug("Connection Factory has already been initialized. Will return cached instance.");
        }
        return this.connectionFactory;
    }

    @Override
    public synchronized void resetConnectionFactory(ConnectionFactory cachedFactory) {
        if (cachedFactory == this.connectionFactory) {
            this.logger.debug("Resetting connection factory");
            this.connectionFactory = null;
        }
    }
}

