/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.server.util;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import org.eclipse.jetty.util.Scanner;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedOperation;
import org.eclipse.jetty.util.component.ContainerLifeCycle;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.ssl.SslContextFactory;

public class TrustStoreScanner
extends ContainerLifeCycle
implements Scanner.DiscreteListener {
    private static final Logger LOG = Log.getLogger(TrustStoreScanner.class);
    private final SslContextFactory sslContextFactory;
    private final File truststoreFile;
    private final Scanner _scanner;

    public TrustStoreScanner(SslContextFactory sslContextFactory) {
        this.sslContextFactory = sslContextFactory;
        try {
            Resource truststoreResource = sslContextFactory.getTrustStoreResource();
            File monitoredFile = truststoreResource.getFile();
            if (monitoredFile == null || !monitoredFile.exists()) {
                throw new IllegalArgumentException("truststore file does not exist");
            }
            if (monitoredFile.isDirectory()) {
                throw new IllegalArgumentException("expected truststore file not directory");
            }
            if (truststoreResource.getAlias() != null) {
                monitoredFile = new File(truststoreResource.getAlias());
            }
            this.truststoreFile = monitoredFile;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Monitored Truststore File: {}", new Object[]{monitoredFile});
            }
        }
        catch (IOException e) {
            throw new IllegalArgumentException("could not obtain truststore file", e);
        }
        File parentFile = this.truststoreFile.getParentFile();
        if (!parentFile.exists() || !parentFile.isDirectory()) {
            throw new IllegalArgumentException("error obtaining truststore dir");
        }
        this._scanner = new Scanner();
        this._scanner.setScanDirs(Collections.singletonList(parentFile));
        this._scanner.setScanInterval(1);
        this._scanner.setReportDirs(false);
        this._scanner.setReportExistingFilesOnStartup(false);
        this._scanner.setScanDepth(1);
        this._scanner.addListener((Scanner.Listener)this);
        this.addBean(this._scanner);
    }

    public void fileAdded(String filename) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("added {}", new Object[]{filename});
        }
        if (this.truststoreFile.toPath().toString().equals(filename)) {
            this.reload();
        }
    }

    public void fileChanged(String filename) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("changed {}", new Object[]{filename});
        }
        if (this.truststoreFile.toPath().toString().equals(filename)) {
            this.reload();
        }
    }

    public void fileRemoved(String filename) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("removed {}", new Object[]{filename});
        }
        if (this.truststoreFile.toPath().toString().equals(filename)) {
            this.reload();
        }
    }

    @ManagedOperation(value="Scan for changes in the SSL Truststore", impact="ACTION")
    public void scan() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("scanning", new Object[0]);
        }
        this._scanner.scan();
        this._scanner.scan();
    }

    @ManagedOperation(value="Reload the SSL Truststore", impact="ACTION")
    public void reload() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("reloading truststore file {}", new Object[]{this.truststoreFile});
        }
        try {
            this.sslContextFactory.reload(scf -> {});
        }
        catch (Throwable t) {
            LOG.warn("Truststore Reload Failed", t);
        }
    }

    @ManagedAttribute(value="scanning interval to detect changes which need reloaded")
    public int getScanInterval() {
        return this._scanner.getScanInterval();
    }

    public void setScanInterval(int scanInterval) {
        this._scanner.setScanInterval(scanInterval);
    }
}

