/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.schemaregistry.hortonworks;

import com.hortonworks.registries.auth.Login;
import com.hortonworks.registries.schemaregistry.client.SchemaRegistryClient;
import java.lang.reflect.Field;
import java.util.Map;
import javax.security.auth.login.LoginException;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.schemaregistry.hortonworks.KerberosUserLogin;
import org.apache.nifi.security.krb.KerberosLoginException;
import org.apache.nifi.security.krb.KerberosPasswordUser;
import org.apache.nifi.security.krb.KerberosUser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaRegistryClientWithKerberosPassword
extends SchemaRegistryClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(SchemaRegistryClientWithKerberosPassword.class);
    public static final String SCHEMA_REGISTRY_CLIENT_KERBEROS_PRINCIPAL = "schema.registry.client.kerberos.principal";
    public static final String SCHEMA_REGISTRY_CLIENT_KERBEROS_PASSWORD = "schema.registry.client.kerberos.password";
    public static final String SCHEMA_REGISTRY_CLIENT_NIFI_COMP_LOGGER = "schema.registry.client.nifi.component.logger";
    private KerberosUser kerberosUser;

    public SchemaRegistryClientWithKerberosPassword(Map<String, ?> conf) {
        super(conf);
    }

    protected void initializeSecurityContext() {
        String principal = (String)this.getConfiguration().getValue(SCHEMA_REGISTRY_CLIENT_KERBEROS_PRINCIPAL);
        if (principal == null) {
            throw new IllegalArgumentException("Failed to login because principal is null");
        }
        String password = (String)this.getConfiguration().getValue(SCHEMA_REGISTRY_CLIENT_KERBEROS_PASSWORD);
        if (password == null) {
            throw new IllegalArgumentException("Failed to login because password is null");
        }
        Object loggerObject = this.getConfiguration().getValue(SCHEMA_REGISTRY_CLIENT_NIFI_COMP_LOGGER);
        if (loggerObject == null) {
            throw new IllegalArgumentException("Failed to login because component logger is required");
        }
        if (!(loggerObject instanceof ComponentLog)) {
            throw new IllegalArgumentException("Failed to login because logger object is not a ComponentLog");
        }
        this.kerberosUser = new KerberosPasswordUser(principal, password);
        KerberosUserLogin login = new KerberosUserLogin(this.kerberosUser, (ComponentLog)loggerObject);
        this.setLogin(login);
        try {
            login.login();
        }
        catch (LoginException | KerberosLoginException e) {
            LOGGER.error("Failed to login as principal `{}`", (Object)principal, (Object)e);
        }
    }

    public void setLogin(Login login) {
        try {
            Field loginField = SchemaRegistryClient.class.getDeclaredField("login");
            loginField.setAccessible(true);
            loginField.set((Object)this, login);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void close() {
        try {
            this.kerberosUser.logout();
        }
        catch (Throwable t) {
            LOGGER.error("Error performing logout of principal during close(): " + t.getMessage(), t);
        }
        finally {
            this.kerberosUser = null;
        }
        super.close();
    }
}

