/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.schemaregistry.hortonworks;

import com.hortonworks.registries.schemaregistry.SchemaIdVersion;
import com.hortonworks.registries.schemaregistry.SchemaMetadata;
import com.hortonworks.registries.schemaregistry.SchemaMetadataInfo;
import com.hortonworks.registries.schemaregistry.SchemaVersionInfo;
import com.hortonworks.registries.schemaregistry.SchemaVersionKey;
import com.hortonworks.registries.schemaregistry.client.SchemaRegistryClient;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import org.apache.avro.Schema;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.DeprecationNotice;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnDisabled;
import org.apache.nifi.annotation.lifecycle.OnEnabled;
import org.apache.nifi.avro.AvroTypeUtil;
import org.apache.nifi.components.AllowableValue;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.controller.AbstractControllerService;
import org.apache.nifi.controller.ConfigurationContext;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.kerberos.KerberosCredentialsService;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.reporting.InitializationException;
import org.apache.nifi.schema.access.SchemaField;
import org.apache.nifi.schema.access.SchemaNotFoundException;
import org.apache.nifi.schemaregistry.hortonworks.SchemaRegistryClientWithKerberosPassword;
import org.apache.nifi.schemaregistry.services.SchemaRegistry;
import org.apache.nifi.serialization.record.RecordSchema;
import org.apache.nifi.serialization.record.SchemaIdentifier;
import org.apache.nifi.ssl.SSLContextService;
import org.apache.nifi.util.Tuple;

@Tags(value={"schema", "registry", "avro", "hortonworks", "hwx"})
@CapabilityDescription(value="Provides a Schema Registry Service that interacts with a Hortonworks Schema Registry, available at https://github.com/hortonworks/registry")
@DeprecationNotice(reason="This controller service is deprecated and will be removed in NiFi 2.x.")
public class HortonworksSchemaRegistry
extends AbstractControllerService
implements SchemaRegistry {
    private static final Set<SchemaField> schemaFields = EnumSet.of(SchemaField.SCHEMA_NAME, new SchemaField[]{SchemaField.SCHEMA_BRANCH_NAME, SchemaField.SCHEMA_TEXT, SchemaField.SCHEMA_TEXT_FORMAT, SchemaField.SCHEMA_IDENTIFIER, SchemaField.SCHEMA_VERSION, SchemaField.SCHEMA_VERSION_ID});
    private static final String CLIENT_SSL_PROPERTY_PREFIX = "schema.registry.client.ssl";
    private final ConcurrentMap<Tuple<SchemaIdentifier, String>, RecordSchema> schemaNameToSchemaMap = new ConcurrentHashMap<Tuple<SchemaIdentifier, String>, RecordSchema>();
    private final ConcurrentMap<Tuple<String, String>, Tuple<SchemaVersionInfo, Long>> schemaVersionByNameCache = new ConcurrentHashMap<Tuple<String, String>, Tuple<SchemaVersionInfo, Long>>();
    private final ConcurrentMap<SchemaVersionKey, Tuple<SchemaVersionInfo, Long>> schemaVersionByKeyCache = new ConcurrentHashMap<SchemaVersionKey, Tuple<SchemaVersionInfo, Long>>();
    private volatile long versionInfoCacheNanos;
    static final PropertyDescriptor URL = new PropertyDescriptor.Builder().name("url").displayName("Schema Registry URL").description("URL of the schema registry that this Controller Service should connect to, including version. For example, http://localhost:9090/api/v1").addValidator(StandardValidators.URL_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).required(true).build();
    static final PropertyDescriptor CACHE_SIZE = new PropertyDescriptor.Builder().name("cache-size").displayName("Cache Size").description("Specifies how many Schemas should be cached from the Hortonworks Schema Registry").addValidator(StandardValidators.NON_NEGATIVE_INTEGER_VALIDATOR).defaultValue("1000").required(true).build();
    static final PropertyDescriptor CACHE_EXPIRATION = new PropertyDescriptor.Builder().name("cache-expiration").displayName("Cache Expiration").description("Specifies how long a Schema that is cached should remain in the cache. Once this time period elapses, a cached version of a schema will no longer be used, and the service will have to communicate with the Hortonworks Schema Registry again in order to obtain the schema.").addValidator(StandardValidators.TIME_PERIOD_VALIDATOR).defaultValue("1 hour").required(true).build();
    static final PropertyDescriptor SSL_CONTEXT_SERVICE = new PropertyDescriptor.Builder().name("ssl-context-service").displayName("SSL Context Service").description("Specifies the SSL Context Service to use for communicating with Schema Registry.").required(false).identifiesControllerService(SSLContextService.class).build();
    static final PropertyDescriptor KERBEROS_CREDENTIALS_SERVICE = new PropertyDescriptor.Builder().name("kerberos-credentials-service").displayName("Kerberos Credentials Service").description("Specifies the Kerberos Credentials Controller Service that should be used for authenticating with Kerberos").identifiesControllerService(KerberosCredentialsService.class).required(false).build();
    static final PropertyDescriptor KERBEROS_PRINCIPAL = new PropertyDescriptor.Builder().name("kerberos-principal").displayName("Kerberos Principal").description("The kerberos principal to authenticate with when not using the kerberos credentials service").defaultValue(null).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).build();
    static final PropertyDescriptor KERBEROS_PASSWORD = new PropertyDescriptor.Builder().name("kerberos-password").displayName("Kerberos Password").description("The password for the kerberos principal when not using the kerberos credentials service").defaultValue(null).required(false).sensitive(true).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    static final PropertyDescriptor BASIC_AUTH_USERNAME = new PropertyDescriptor.Builder().name("basic-auth-username").displayName("Basic Authentication Username").description("The username to use for basic authentication when the Schema Registry is behind a proxy such as Apache Knox.").addValidator(StandardValidators.NON_EMPTY_VALIDATOR).dependsOn(SSL_CONTEXT_SERVICE, new AllowableValue[0]).build();
    static final PropertyDescriptor BASIC_AUTH_PASSWORD = new PropertyDescriptor.Builder().name("basic-auth-password").displayName("Basic Authentication Password").description("The password to use for basic authentication when the Schema Registry is behind a proxy such as Apache Knox.").sensitive(true).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).dependsOn(SSL_CONTEXT_SERVICE, new AllowableValue[0]).build();
    private volatile boolean usingKerberosWithPassword = false;
    private volatile SchemaRegistryClient schemaRegistryClient;
    private volatile boolean initialized;
    private volatile Map<String, Object> schemaRegistryConfig;

    protected Collection<ValidationResult> customValidate(ValidationContext validationContext) {
        ArrayList<ValidationResult> results = new ArrayList<ValidationResult>();
        String kerberosPrincipal = validationContext.getProperty(KERBEROS_PRINCIPAL).evaluateAttributeExpressions().getValue();
        String kerberosPassword = validationContext.getProperty(KERBEROS_PASSWORD).getValue();
        String basicAuthUsername = validationContext.getProperty(BASIC_AUTH_USERNAME).evaluateAttributeExpressions().getValue();
        KerberosCredentialsService kerberosCredentialsService = (KerberosCredentialsService)validationContext.getProperty(KERBEROS_CREDENTIALS_SERVICE).asControllerService(KerberosCredentialsService.class);
        if (kerberosCredentialsService != null && !StringUtils.isBlank((CharSequence)kerberosPrincipal) && !StringUtils.isBlank((CharSequence)kerberosPassword)) {
            results.add(new ValidationResult.Builder().subject(KERBEROS_CREDENTIALS_SERVICE.getDisplayName()).valid(false).explanation("kerberos principal/password and kerberos credential service cannot be configured at the same time").build());
        }
        if (!StringUtils.isBlank((CharSequence)kerberosPrincipal) && StringUtils.isBlank((CharSequence)kerberosPassword)) {
            results.add(new ValidationResult.Builder().subject(KERBEROS_PASSWORD.getDisplayName()).valid(false).explanation("kerberos password is required when specifying a kerberos principal").build());
        }
        if (StringUtils.isBlank((CharSequence)kerberosPrincipal) && !StringUtils.isBlank((CharSequence)kerberosPassword)) {
            results.add(new ValidationResult.Builder().subject(KERBEROS_PRINCIPAL.getDisplayName()).valid(false).explanation("kerberos principal is required when specifying a kerberos password").build());
        }
        if ((validationContext.getProperty(BASIC_AUTH_USERNAME).isSet() || validationContext.getProperty(BASIC_AUTH_PASSWORD).isSet()) && !validationContext.getProperty(SSL_CONTEXT_SERVICE).isSet()) {
            results.add(new ValidationResult.Builder().subject(BASIC_AUTH_USERNAME.getDisplayName()).valid(false).explanation("SSL Context Service must be set when using basic authentication").build());
        }
        if (!(StringUtils.isBlank((CharSequence)kerberosPrincipal) && kerberosCredentialsService == null || StringUtils.isBlank((CharSequence)basicAuthUsername))) {
            results.add(new ValidationResult.Builder().subject(BASIC_AUTH_USERNAME.getDisplayName()).valid(false).explanation("kerberos- and basic authentication cannot be configured at the same time").build());
        }
        return results;
    }

    @OnEnabled
    public void enable(ConfigurationContext context) throws InitializationException {
        this.schemaRegistryConfig = new HashMap<String, Object>();
        this.versionInfoCacheNanos = context.getProperty(CACHE_EXPIRATION).asTimePeriod(TimeUnit.NANOSECONDS);
        String urlValue = context.getProperty(URL).evaluateAttributeExpressions().getValue();
        if (urlValue == null || urlValue.trim().isEmpty()) {
            throw new IllegalArgumentException("'Schema Registry URL' must not be null or empty.");
        }
        this.schemaRegistryConfig.put(SchemaRegistryClient.Configuration.SCHEMA_REGISTRY_URL.name(), urlValue);
        this.schemaRegistryConfig.put(SchemaRegistryClient.Configuration.CLASSLOADER_CACHE_SIZE.name(), 10);
        this.schemaRegistryConfig.put(SchemaRegistryClient.Configuration.CLASSLOADER_CACHE_EXPIRY_INTERVAL_SECS.name(), context.getProperty(CACHE_EXPIRATION).asTimePeriod(TimeUnit.SECONDS).intValue());
        this.schemaRegistryConfig.put(SchemaRegistryClient.Configuration.SCHEMA_VERSION_CACHE_SIZE.name(), context.getProperty(CACHE_SIZE).asInteger());
        this.schemaRegistryConfig.put(SchemaRegistryClient.Configuration.SCHEMA_VERSION_CACHE_EXPIRY_INTERVAL_SECS.name(), context.getProperty(CACHE_EXPIRATION).asTimePeriod(TimeUnit.SECONDS).intValue());
        Map<String, String> sslProperties = this.buildSslProperties(context);
        if (!sslProperties.isEmpty()) {
            this.schemaRegistryConfig.put(CLIENT_SSL_PROPERTY_PREFIX, sslProperties);
        }
        String kerberosPrincipal = context.getProperty(KERBEROS_PRINCIPAL).evaluateAttributeExpressions().getValue();
        String kerberosPassword = context.getProperty(KERBEROS_PASSWORD).getValue();
        KerberosCredentialsService kerberosCredentialsService = (KerberosCredentialsService)context.getProperty(KERBEROS_CREDENTIALS_SERVICE).asControllerService(KerberosCredentialsService.class);
        if (kerberosCredentialsService != null) {
            String principal = kerberosCredentialsService.getPrincipal();
            String keytab = kerberosCredentialsService.getKeytab();
            String jaasConfigString = this.getKeytabJaasConfig(principal, keytab);
            this.schemaRegistryConfig.put(SchemaRegistryClient.Configuration.SASL_JAAS_CONFIG.name(), jaasConfigString);
            this.usingKerberosWithPassword = false;
        } else if (!StringUtils.isBlank((CharSequence)kerberosPrincipal) && !StringUtils.isBlank((CharSequence)kerberosPassword)) {
            this.schemaRegistryConfig.put("schema.registry.client.kerberos.principal", kerberosPrincipal);
            this.schemaRegistryConfig.put("schema.registry.client.kerberos.password", kerberosPassword);
            this.schemaRegistryConfig.put("schema.registry.client.nifi.component.logger", this.getLogger());
            this.usingKerberosWithPassword = true;
        }
        if (context.getProperty(BASIC_AUTH_USERNAME).isSet()) {
            this.schemaRegistryConfig.put(SchemaRegistryClient.Configuration.AUTH_USERNAME.name(), context.getProperty(BASIC_AUTH_USERNAME).getValue());
        }
        if (context.getProperty(BASIC_AUTH_PASSWORD).isSet()) {
            this.schemaRegistryConfig.put(SchemaRegistryClient.Configuration.AUTH_PASSWORD.name(), context.getProperty(BASIC_AUTH_PASSWORD).getValue());
        }
    }

    private String getKeytabJaasConfig(String principal, String keytab) {
        return "com.sun.security.auth.module.Krb5LoginModule required useTicketCache=false renewTicket=true useKeyTab=true keyTab=\"" + keytab + "\" principal=\"" + principal + "\";";
    }

    private Map<String, String> buildSslProperties(ConfigurationContext context) {
        SSLContextService sslContextService = (SSLContextService)context.getProperty(SSL_CONTEXT_SERVICE).asControllerService(SSLContextService.class);
        HashMap<String, String> propertiesBuilder = new HashMap<String, String>();
        if (sslContextService != null) {
            propertiesBuilder.put("protocol", sslContextService.getSslAlgorithm());
            if (sslContextService.isKeyStoreConfigured()) {
                propertiesBuilder.put("keyStorePath", sslContextService.getKeyStoreFile());
                propertiesBuilder.put("keyStorePassword", sslContextService.getKeyStorePassword());
                propertiesBuilder.put("keyStoreType", sslContextService.getKeyStoreType());
                if (sslContextService.getKeyPassword() != null) {
                    propertiesBuilder.put("keyPassword", sslContextService.getKeyPassword());
                }
            }
            if (sslContextService.isTrustStoreConfigured()) {
                propertiesBuilder.put("trustStorePath", sslContextService.getTrustStoreFile());
                propertiesBuilder.put("trustStorePassword", sslContextService.getTrustStorePassword());
                propertiesBuilder.put("trustStoreType", sslContextService.getTrustStoreType());
            }
        }
        return Collections.unmodifiableMap(propertiesBuilder);
    }

    @OnDisabled
    public void close() {
        if (this.schemaRegistryClient != null) {
            this.schemaRegistryClient.close();
        }
        this.initialized = false;
        this.usingKerberosWithPassword = false;
    }

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        ArrayList<PropertyDescriptor> properties = new ArrayList<PropertyDescriptor>();
        properties.add(URL);
        properties.add(CACHE_SIZE);
        properties.add(CACHE_EXPIRATION);
        properties.add(SSL_CONTEXT_SERVICE);
        properties.add(KERBEROS_CREDENTIALS_SERVICE);
        properties.add(KERBEROS_PRINCIPAL);
        properties.add(KERBEROS_PASSWORD);
        properties.add(BASIC_AUTH_USERNAME);
        properties.add(BASIC_AUTH_PASSWORD);
        return properties;
    }

    protected synchronized SchemaRegistryClient getClient() {
        if (!this.initialized) {
            this.schemaRegistryClient = this.usingKerberosWithPassword ? new SchemaRegistryClientWithKerberosPassword(this.schemaRegistryConfig) : new SchemaRegistryClient(this.schemaRegistryConfig);
            this.initialized = true;
        }
        return this.schemaRegistryClient;
    }

    private SchemaVersionInfo getLatestSchemaVersionInfo(SchemaRegistryClient client, String schemaName, String branchName) throws SchemaNotFoundException {
        try {
            Tuple nameAndBranch = new Tuple((Object)schemaName, (Object)branchName);
            Tuple timestampedVersionInfo = (Tuple)this.schemaVersionByNameCache.get(nameAndBranch);
            boolean fetch = false;
            if (timestampedVersionInfo == null) {
                fetch = true;
            } else {
                long minTimestamp = System.nanoTime() - this.versionInfoCacheNanos;
                boolean bl = fetch = (Long)timestampedVersionInfo.getValue() < minTimestamp;
            }
            if (!fetch) {
                return (SchemaVersionInfo)timestampedVersionInfo.getKey();
            }
            SchemaVersionInfo versionInfo = StringUtils.isBlank((CharSequence)branchName) ? client.getLatestSchemaVersionInfo(schemaName) : client.getLatestSchemaVersionInfo(branchName, schemaName);
            if (versionInfo == null) {
                throw new SchemaNotFoundException("Could not find schema with name '" + schemaName + "'");
            }
            Tuple tuple = new Tuple((Object)versionInfo, (Object)System.nanoTime());
            this.schemaVersionByNameCache.put((Tuple<String, String>)nameAndBranch, (Tuple<SchemaVersionInfo, Long>)tuple);
            return versionInfo;
        }
        catch (com.hortonworks.registries.schemaregistry.errors.SchemaNotFoundException e) {
            throw new SchemaNotFoundException((Throwable)e);
        }
    }

    private SchemaVersionInfo getSchemaVersionInfo(SchemaRegistryClient client, SchemaVersionKey key) throws SchemaNotFoundException {
        try {
            Tuple timestampedVersionInfo = (Tuple)this.schemaVersionByKeyCache.get(key);
            boolean fetch = false;
            if (timestampedVersionInfo == null) {
                fetch = true;
            } else {
                long minTimestamp = System.nanoTime() - this.versionInfoCacheNanos;
                boolean bl = fetch = (Long)timestampedVersionInfo.getValue() < minTimestamp;
            }
            if (!fetch) {
                return (SchemaVersionInfo)timestampedVersionInfo.getKey();
            }
            SchemaVersionInfo versionInfo = client.getSchemaVersionInfo(key);
            if (versionInfo == null) {
                throw new SchemaNotFoundException("Could not find schema with name '" + key.getSchemaName() + "' and version " + key.getVersion());
            }
            Tuple tuple = new Tuple((Object)versionInfo, (Object)System.nanoTime());
            this.schemaVersionByKeyCache.put(key, (Tuple<SchemaVersionInfo, Long>)tuple);
            return versionInfo;
        }
        catch (com.hortonworks.registries.schemaregistry.errors.SchemaNotFoundException e) {
            throw new SchemaNotFoundException((Throwable)e);
        }
    }

    private RecordSchema retrieveSchemaByName(SchemaIdentifier schemaIdentifier) throws SchemaNotFoundException, IOException {
        SchemaVersionInfo versionInfo;
        Long schemaId;
        SchemaRegistryClient client = this.getClient();
        Optional schemaName = schemaIdentifier.getName();
        if (!schemaName.isPresent()) {
            throw new SchemaNotFoundException("Cannot retrieve schema because Schema Name is not present");
        }
        Optional schemaBranchName = schemaIdentifier.getBranch();
        OptionalInt schemaVersion = schemaIdentifier.getVersion();
        try {
            SchemaMetadataInfo metadataInfo = client.getSchemaMetadataInfo((String)schemaName.get());
            if (metadataInfo == null) {
                throw new SchemaNotFoundException("Could not find schema with name '" + schemaName + "'");
            }
            schemaId = metadataInfo.getId();
            if (schemaId == null) {
                throw new SchemaNotFoundException("Could not find schema with name '" + schemaName + "'");
            }
            if (schemaVersion.isPresent()) {
                SchemaVersionKey schemaVersionKey = new SchemaVersionKey((String)schemaName.get(), Integer.valueOf(schemaVersion.getAsInt()));
                versionInfo = this.getSchemaVersionInfo(client, schemaVersionKey);
            } else {
                versionInfo = this.getLatestSchemaVersionInfo(client, (String)schemaName.get(), schemaBranchName.orElse(null));
            }
            if (versionInfo == null || versionInfo.getVersion() == null) {
                String message = this.createErrorMessage("Could not find schema", schemaName, schemaBranchName, schemaVersion);
                throw new SchemaNotFoundException(message);
            }
        }
        catch (Exception e) {
            String message = this.createErrorMessage("Failed to retrieve schema", schemaName, schemaBranchName, schemaVersion);
            this.handleException(message, e);
            return null;
        }
        String schemaText = versionInfo.getSchemaText();
        SchemaIdentifier resultSchemaIdentifier = SchemaIdentifier.builder().id(schemaId).name((String)schemaName.get()).branch((String)schemaBranchName.orElse(null)).version(versionInfo.getVersion()).schemaVersionId(versionInfo.getId()).build();
        Tuple tuple = new Tuple((Object)resultSchemaIdentifier, (Object)schemaText);
        return this.schemaNameToSchemaMap.computeIfAbsent((Tuple<SchemaIdentifier, String>)tuple, t -> {
            Schema schema = new Schema.Parser().parse(schemaText);
            return AvroTypeUtil.createSchema((Schema)schema, (String)schemaText, (SchemaIdentifier)resultSchemaIdentifier);
        });
    }

    private RecordSchema retrieveSchemaByIdAndVersion(SchemaIdentifier schemaIdentifier) throws SchemaNotFoundException, IOException {
        SchemaVersionInfo versionInfo;
        String schemaName;
        SchemaRegistryClient client = this.getClient();
        OptionalLong schemaId = schemaIdentifier.getIdentifier();
        if (!schemaId.isPresent()) {
            throw new SchemaNotFoundException("Cannot retrieve schema because Schema Id is not present");
        }
        OptionalInt version = schemaIdentifier.getVersion();
        if (!version.isPresent()) {
            throw new SchemaNotFoundException("Cannot retrieve schema because Schema Version is not present");
        }
        try {
            SchemaMetadataInfo info = client.getSchemaMetadataInfo(Long.valueOf(schemaId.getAsLong()));
            if (info == null) {
                throw new SchemaNotFoundException("Could not find schema with ID '" + schemaId + "' and version '" + version + "'");
            }
            SchemaMetadata metadata = info.getSchemaMetadata();
            schemaName = metadata.getName();
            SchemaVersionKey schemaVersionKey = new SchemaVersionKey(schemaName, Integer.valueOf(version.getAsInt()));
            versionInfo = this.getSchemaVersionInfo(client, schemaVersionKey);
            if (versionInfo == null) {
                throw new SchemaNotFoundException("Could not find schema with ID '" + schemaId + "' and version '" + version + "'");
            }
        }
        catch (Exception e) {
            this.handleException("Failed to retrieve schema with ID '" + schemaId + "' and version '" + version + "'", e);
            return null;
        }
        String schemaText = versionInfo.getSchemaText();
        SchemaIdentifier resultSchemaIdentifier = SchemaIdentifier.builder().name(schemaName).id(Long.valueOf(schemaId.getAsLong())).version(Integer.valueOf(version.getAsInt())).schemaVersionId(versionInfo.getId()).build();
        Tuple tuple = new Tuple((Object)resultSchemaIdentifier, (Object)schemaText);
        return this.schemaNameToSchemaMap.computeIfAbsent((Tuple<SchemaIdentifier, String>)tuple, t -> {
            Schema schema = new Schema.Parser().parse(schemaText);
            return AvroTypeUtil.createSchema((Schema)schema, (String)schemaText, (SchemaIdentifier)resultSchemaIdentifier);
        });
    }

    public RecordSchema retrieveSchema(SchemaIdentifier schemaIdentifier) throws IOException, SchemaNotFoundException {
        if (schemaIdentifier.getSchemaVersionId().isPresent()) {
            return this.retrieveSchemaBySchemaVersionId(schemaIdentifier);
        }
        if (schemaIdentifier.getIdentifier().isPresent()) {
            return this.retrieveSchemaByIdAndVersion(schemaIdentifier);
        }
        return this.retrieveSchemaByName(schemaIdentifier);
    }

    private RecordSchema retrieveSchemaBySchemaVersionId(SchemaIdentifier schemaIdentifier) throws IOException, SchemaNotFoundException {
        String schemaName;
        SchemaVersionInfo versionInfo;
        SchemaRegistryClient client = this.getClient();
        OptionalLong schemaVersionId = schemaIdentifier.getSchemaVersionId();
        SchemaIdVersion svi = new SchemaIdVersion(Long.valueOf(schemaVersionId.getAsLong()));
        try {
            versionInfo = client.getSchemaVersionInfo(svi);
            schemaName = versionInfo.getName();
        }
        catch (Exception e) {
            this.handleException("Failed to retrieve schema with Schema Version ID '" + schemaVersionId.getAsLong() + "'", e);
            return null;
        }
        String schemaText = versionInfo.getSchemaText();
        SchemaIdentifier resultSchemaIdentifier = SchemaIdentifier.builder().name(schemaName).id(versionInfo.getSchemaMetadataId()).version(versionInfo.getVersion()).schemaVersionId(Long.valueOf(schemaVersionId.getAsLong())).build();
        Tuple tuple = new Tuple((Object)resultSchemaIdentifier, (Object)schemaText);
        return this.schemaNameToSchemaMap.computeIfAbsent((Tuple<SchemaIdentifier, String>)tuple, t -> {
            Schema schema = new Schema.Parser().parse(schemaText);
            return AvroTypeUtil.createSchema((Schema)schema, (String)schemaText, (SchemaIdentifier)resultSchemaIdentifier);
        });
    }

    private String createErrorMessage(String baseMessage, Optional<String> schemaName, Optional<String> branchName, OptionalInt version) {
        StringBuilder builder = new StringBuilder(baseMessage).append(" with name '").append(schemaName.orElse("null")).append("'");
        if (branchName.isPresent()) {
            builder.append(" and branch '").append(branchName.get()).append("'");
        }
        if (version.isPresent()) {
            builder.append(" and version '").append(version.getAsInt()).append("'");
        }
        return builder.toString();
    }

    private void handleException(String message, Exception e) throws IOException, SchemaNotFoundException {
        if (this.containsIOException(e)) {
            throw new IOException(message, e);
        }
        throw new SchemaNotFoundException(message, (Throwable)e);
    }

    private boolean containsIOException(Throwable t) {
        if (t == null) {
            return false;
        }
        if (t instanceof IOException) {
            return true;
        }
        Throwable cause = t.getCause();
        if (cause == null) {
            return false;
        }
        return this.containsIOException(cause);
    }

    public Set<SchemaField> getSuppliedSchemaFields() {
        return schemaFields;
    }
}

