/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.hl7.query.evaluator.comparison;

import java.util.Collection;
import java.util.Map;
import org.apache.nifi.hl7.model.HL7Component;
import org.apache.nifi.hl7.query.evaluator.BooleanEvaluator;
import org.apache.nifi.hl7.query.evaluator.Evaluator;

public class NotNullEvaluator
extends BooleanEvaluator {
    private final Evaluator<?> subjectEvaluator;

    public NotNullEvaluator(Evaluator<?> subjectEvaluator) {
        this.subjectEvaluator = subjectEvaluator;
    }

    @Override
    public Boolean evaluate(Map<String, Object> objectMap) {
        Object subjectValue = this.subjectEvaluator.evaluate(objectMap);
        if (subjectValue == null) {
            return false;
        }
        return this.isNotNull(subjectValue);
    }

    private boolean isNotNull(Object subjectValue) {
        if (subjectValue instanceof HL7Component) {
            subjectValue = ((HL7Component)subjectValue).getValue();
        }
        if (subjectValue instanceof Collection) {
            Collection collection = (Collection)subjectValue;
            if (collection.isEmpty()) {
                return false;
            }
            for (Object obj : collection) {
                if (!this.isNotNull(obj)) continue;
                return true;
            }
            return false;
        }
        return subjectValue != null;
    }
}

