/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.hl7.hapi;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.Segment;
import ca.uhn.hl7v2.model.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.nifi.hl7.hapi.EmptyField;
import org.apache.nifi.hl7.hapi.HapiField;
import org.apache.nifi.hl7.model.HL7Field;
import org.apache.nifi.hl7.model.HL7Segment;

public class HapiSegment
implements HL7Segment {
    private final Segment segment;
    private final List<HL7Field> fields;

    public HapiSegment(Segment segment) throws HL7Exception {
        this.segment = segment;
        ArrayList<HL7Field> fieldList = new ArrayList<HL7Field>();
        for (int i = 1; i <= segment.numFields(); ++i) {
            Type[] types = segment.getField(i);
            if (types == null || types.length == 0) {
                fieldList.add(new EmptyField());
                continue;
            }
            for (Type type : types) {
                fieldList.add(new HapiField(type));
            }
        }
        this.fields = Collections.unmodifiableList(fieldList);
    }

    @Override
    public String getName() {
        return this.segment.getName();
    }

    @Override
    public List<HL7Field> getFields() {
        return this.fields;
    }

    public String toString() {
        return this.segment.toString();
    }
}

