/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.hl7.query.result;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.nifi.hl7.query.QueryResult;
import org.apache.nifi.hl7.query.ResultHit;
import org.apache.nifi.hl7.query.Selection;
import org.apache.nifi.hl7.query.result.StandardResultHit;

public class StandardQueryResult
implements QueryResult {
    private final List<Selection> selections;
    private final Set<Map<String, Object>> hits;
    private final Iterator<Map<String, Object>> hitIterator;

    public StandardQueryResult(List<Selection> selections, Set<Map<String, Object>> hits) {
        this.selections = selections;
        this.hits = hits;
        this.hitIterator = hits.iterator();
    }

    @Override
    public boolean isMatch() {
        return !this.hits.isEmpty();
    }

    @Override
    public List<String> getLabels() {
        ArrayList<String> labels = new ArrayList<String>();
        for (Selection selection : this.selections) {
            labels.add(selection.getName());
        }
        return labels;
    }

    @Override
    public int getHitCount() {
        return this.hits.size();
    }

    @Override
    public ResultHit nextHit() {
        if (this.hitIterator.hasNext()) {
            return new StandardResultHit(this.hitIterator.next());
        }
        return null;
    }
}

