/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.util.hive;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.hadoop.KerberosProperties;
import org.apache.nifi.hadoop.SecurityUtil;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.security.krb.KerberosUser;
import org.apache.nifi.util.hive.AuthenticationFailedException;
import org.apache.nifi.util.hive.ValidationResources;

public class HiveConfigurator {
    public Collection<ValidationResult> validate(String configFiles, String principal, String keyTab, String password, AtomicReference<ValidationResources> validationResourceHolder, ComponentLog log) {
        ArrayList<ValidationResult> problems = new ArrayList<ValidationResult>();
        ValidationResources resources = validationResourceHolder.get();
        if (resources == null || !configFiles.equals(resources.getConfigResources())) {
            log.debug("Reloading validation resources");
            resources = new ValidationResources(configFiles, (Configuration)this.getConfigurationFromFiles(configFiles));
            validationResourceHolder.set(resources);
        }
        Configuration hiveConfig = resources.getConfiguration();
        problems.addAll(KerberosProperties.validatePrincipalWithKeytabOrPassword((String)this.getClass().getSimpleName(), (Configuration)hiveConfig, (String)principal, (String)keyTab, (String)password, (ComponentLog)log));
        return problems;
    }

    public HiveConf getConfigurationFromFiles(String configFiles) {
        HiveConf hiveConfig = new HiveConf();
        if (StringUtils.isNotBlank((CharSequence)configFiles)) {
            for (String configFile : configFiles.split(",")) {
                hiveConfig.addResource(new Path(configFile.trim()));
            }
        }
        return hiveConfig;
    }

    public void preload(Configuration configuration) {
        try {
            FileSystem.get((Configuration)configuration).close();
            UserGroupInformation.setConfiguration((Configuration)configuration);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public UserGroupInformation authenticate(Configuration hiveConfig, KerberosUser kerberosUser) throws AuthenticationFailedException {
        try {
            return SecurityUtil.getUgiForKerberosUser((Configuration)hiveConfig, (KerberosUser)kerberosUser);
        }
        catch (IOException ioe) {
            throw new AuthenticationFailedException("Kerberos Authentication for Hive failed", ioe);
        }
    }

    @Deprecated
    public UserGroupInformation authenticate(Configuration hiveConfig, String principal, String keyTab) throws AuthenticationFailedException {
        UserGroupInformation ugi;
        try {
            ugi = SecurityUtil.loginKerberos((Configuration)hiveConfig, (String)principal, (String)keyTab);
        }
        catch (IOException ioe) {
            throw new AuthenticationFailedException("Kerberos Authentication for Hive failed", ioe);
        }
        return ugi;
    }

    @Deprecated
    public UserGroupInformation authenticate(Configuration hiveConfig, String principal, String keyTab, long ticketRenewalPeriod) throws AuthenticationFailedException {
        return this.authenticate(hiveConfig, principal, keyTab);
    }
}

