/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.hive.metastore;

import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.HiveMetaStoreClient;
import org.apache.nifi.hive.metastore.MetastoreCore;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.ExtensionContext;

public class ThriftMetastore
implements BeforeAllCallback,
AfterAllCallback {
    private final MetastoreCore metastoreCore;
    private Map<String, String> configOverrides = new HashMap<String, String>();

    public ThriftMetastore() {
        this.metastoreCore = new MetastoreCore();
    }

    public ThriftMetastore withConfigOverrides(Map<String, String> configs) {
        this.configOverrides = configs;
        return this;
    }

    public void beforeAll(ExtensionContext context) throws Exception {
        this.metastoreCore.initialize(this.configOverrides);
    }

    public void afterAll(ExtensionContext context) {
        this.metastoreCore.shutdown();
    }

    public String getThriftConnectionUri() {
        return this.metastoreCore.getThriftConnectionUri();
    }

    public String getWarehouseLocation() {
        return this.metastoreCore.getWarehouseLocation();
    }

    public HiveMetaStoreClient getMetaStoreClient() {
        return this.metastoreCore.getMetaStoreClient();
    }

    public Configuration getConfiguration() {
        return this.metastoreCore.getConfiguration();
    }

    public String getConfigurationLocation() {
        return this.metastoreCore.getConfigurationLocation();
    }
}

