/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.hadoop.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.fs.FileStatus;

public class FileStatusManager {
    private final List<String> currentLatestFiles;
    private long currentLatestTimestamp;

    public FileStatusManager(long initialLatestTimestamp, List<String> initialLatestFiles) {
        this.currentLatestTimestamp = initialLatestTimestamp;
        this.currentLatestFiles = new ArrayList<String>(initialLatestFiles);
    }

    public void update(FileStatus status) {
        if (status.getModificationTime() > this.currentLatestTimestamp) {
            this.currentLatestTimestamp = status.getModificationTime();
            this.currentLatestFiles.clear();
            this.currentLatestFiles.add(status.getPath().toString());
        } else if (status.getModificationTime() == this.currentLatestTimestamp) {
            this.currentLatestFiles.add(status.getPath().toString());
        }
    }

    public List<String> getCurrentLatestFiles() {
        return Collections.unmodifiableList(this.currentLatestFiles);
    }

    public long getCurrentLatestTimestamp() {
        return this.currentLatestTimestamp;
    }
}

