/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.hadoop;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.processors.hadoop.SequenceFileWriterImpl;
import org.apache.nifi.processors.hadoop.util.InputStreamWritable;
import org.slf4j.LoggerFactory;

public class TarUnpackerSequenceFileWriter
extends SequenceFileWriterImpl {
    @Override
    protected void processInputStream(InputStream stream, FlowFile tarArchivedFlowFile, SequenceFile.Writer writer) throws IOException {
        try (TarArchiveInputStream tarIn = new TarArchiveInputStream((InputStream)new BufferedInputStream(stream));){
            TarArchiveEntry tarEntry;
            while ((tarEntry = tarIn.getNextTarEntry()) != null) {
                if (tarEntry.isDirectory()) continue;
                String key = tarEntry.getName();
                long fileSize = tarEntry.getSize();
                InputStreamWritable inStreamWritable = new InputStreamWritable((InputStream)tarIn, (int)fileSize);
                writer.append((Writable)new Text(key), (Writable)inStreamWritable);
                logger.debug("Appending FlowFile {} to Sequence File", (Object)key);
            }
        }
    }

    static {
        logger = LoggerFactory.getLogger(TarUnpackerSequenceFileWriter.class);
    }
}

