/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.hbase.io;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.nifi.hbase.io.RowSerializer;
import org.apache.nifi.hbase.scan.ResultCell;
import org.apache.nifi.hbase.util.RowSerializerUtil;

public class JsonQualifierAndValueRowSerializer
implements RowSerializer {
    private final Charset decodeCharset;
    private final Charset encodeCharset;
    private final boolean base64encode;

    public JsonQualifierAndValueRowSerializer(Charset decodeCharset, Charset encodeCharset) {
        this(decodeCharset, encodeCharset, false);
    }

    public JsonQualifierAndValueRowSerializer(Charset decodeCharset, Charset encodeCharset, boolean base64encode) {
        this.decodeCharset = decodeCharset;
        this.encodeCharset = encodeCharset;
        this.base64encode = base64encode;
    }

    @Override
    public String serialize(byte[] rowKey, ResultCell[] cells) {
        StringBuilder jsonBuilder = new StringBuilder();
        jsonBuilder.append("{");
        int i = 0;
        for (ResultCell cell : cells) {
            String cellQualifier = RowSerializerUtil.getCellQualifier(cell, this.decodeCharset, this.base64encode);
            String cellValue = RowSerializerUtil.getCellValue(cell, this.decodeCharset, this.base64encode);
            if (i > 0) {
                jsonBuilder.append(", ");
            }
            this.appendString(jsonBuilder, cellQualifier, this.base64encode);
            jsonBuilder.append(":");
            this.appendString(jsonBuilder, cellValue, this.base64encode);
            ++i;
        }
        jsonBuilder.append("}");
        return jsonBuilder.toString();
    }

    @Override
    public void serialize(byte[] rowKey, ResultCell[] cells, OutputStream out) throws IOException {
        String json = this.serialize(rowKey, cells);
        out.write(json.getBytes(this.encodeCharset));
    }

    private void appendString(StringBuilder jsonBuilder, String str, boolean base64encode) {
        jsonBuilder.append("\"");
        if (!base64encode) {
            jsonBuilder.append(StringEscapeUtils.escapeJson((String)str));
        } else {
            jsonBuilder.append(str);
        }
        jsonBuilder.append("\"");
    }
}

