/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.hbase.mapr;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.ClusterStatus;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.ParseFilter;
import org.apache.hadoop.hbase.security.visibility.Authorizations;
import org.apache.hadoop.hbase.security.visibility.CellVisibility;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.nifi.annotation.behavior.DynamicProperty;
import org.apache.nifi.annotation.behavior.RequiresInstanceClassLoading;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnDisabled;
import org.apache.nifi.annotation.lifecycle.OnEnabled;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.controller.AbstractControllerService;
import org.apache.nifi.controller.ConfigurationContext;
import org.apache.nifi.hbase.DeleteRequest;
import org.apache.nifi.hbase.HBaseClientService;
import org.apache.nifi.hbase.put.PutColumn;
import org.apache.nifi.hbase.put.PutFlowFile;
import org.apache.nifi.hbase.scan.Column;
import org.apache.nifi.hbase.scan.ResultCell;
import org.apache.nifi.hbase.scan.ResultHandler;
import org.apache.nifi.util.mapr.MapRComponentsUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RequiresInstanceClassLoading
@Tags(value={"hbase", "client", "maprdb"})
@CapabilityDescription(value="Implementation of Hbase and maprdb service which can establish connection to hbase within MapR cluster. Caution !!! -> Service can be launched only on the cluster's nodes with installed and configured hbase-client.")
@DynamicProperty(name="The name of an HBase configuration property.", value="The value of the given HBase configuration property.", description="These properties will be set on the HBase configuration after loading any provided configuration files.")
public class EEP_HbaseMaprDbClientService
extends AbstractControllerService
implements HBaseClientService {
    private static final Logger logger = LoggerFactory.getLogger(EEP_HbaseMaprDbClientService.class);
    protected volatile Connection connection;
    private volatile String masterAddress;
    private volatile String hbaseConfPath = null;
    private static final String HBASE_COMPONENT_NAME = "hbase";
    private static final String HBASE_CONF_INTERNAL_PATH = "/conf";
    private static final String HBASE_CONF_SITE_XML = "hbase-site.xml";

    @OnEnabled
    public void onEnabled(ConfigurationContext context) throws IOException {
        Configuration conf = this.createConfiguration();
        this.connection = this.createConnection(conf);
        this.connectionCheck(context);
    }

    protected Collection<ValidationResult> customValidate(ValidationContext validationContext) {
        ArrayList<ValidationResult> problems = new ArrayList<ValidationResult>();
        try {
            this.hbaseConfPath = this.getHbaseConfFolder();
        }
        catch (RuntimeException e) {
            problems.add(new ValidationResult.Builder().valid(false).subject(((Object)((Object)this)).getClass().getSimpleName()).explanation("Hbase client not installed !!!").build());
        }
        return problems;
    }

    public String getHbaseConfFolder() {
        String hbaseFolder;
        try {
            hbaseFolder = MapRComponentsUtils.getComponentFolder((String)HBASE_COMPONENT_NAME).toString();
        }
        catch (IOException e) {
            throw new RuntimeException("Hbase not installed!!!", e);
        }
        return Paths.get(hbaseFolder, HBASE_CONF_INTERNAL_PATH).toString();
    }

    protected Configuration createConfiguration() {
        Configuration hbaseConfig = HBaseConfiguration.create();
        hbaseConfig.addResource(new Path(this.hbaseConfPath, HBASE_CONF_SITE_XML));
        return hbaseConfig;
    }

    @OnDisabled
    public void shutdown() {
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (IOException ioe) {
                logger.error("Failed to close connection to HBase due to {}", (Object)ioe.getMessage());
            }
        }
    }

    protected void connectionCheck(ConfigurationContext context) throws IOException {
        Admin admin;
        if (this.connection != null && (admin = this.connection.getAdmin()) != null) {
            admin.listTableNames();
            ClusterStatus clusterStatus = admin.getClusterStatus();
            if (clusterStatus != null) {
                ServerName master = clusterStatus.getMaster();
                this.masterAddress = master != null ? master.getHostAndPort() : null;
            }
        }
    }

    protected Connection createConnection(Configuration conf) throws IOException {
        Connection connection = null;
        try {
            logger.debug("Connections Start");
            connection = ConnectionFactory.createConnection((Configuration)conf);
            logger.debug("Connections Established");
        }
        catch (IOException e) {
            logger.error("Connections failed e={}, {}", (Object)e.getMessage(), (Object)e);
        }
        return connection;
    }

    protected List<Put> buildPuts(byte[] rowKey, List<PutColumn> columns) throws IOException {
        ArrayList<Put> retVal = new ArrayList<Put>();
        try {
            Put put = null;
            for (PutColumn column : columns) {
                if (put == null || put.getCellVisibility() == null && column.getVisibility() != null || put.getCellVisibility() != null && !put.getCellVisibility().getExpression().equals(column.getVisibility())) {
                    put = new Put(rowKey);
                    if (column.getVisibility() != null) {
                        put.setCellVisibility(new CellVisibility(column.getVisibility()));
                    }
                    retVal.add(put);
                }
                if (column.getTimestamp() != null) {
                    put.addColumn(column.getColumnFamily(), column.getColumnQualifier(), column.getTimestamp().longValue(), column.getBuffer());
                    continue;
                }
                put.addColumn(column.getColumnFamily(), column.getColumnQualifier(), column.getBuffer());
            }
        }
        catch (DeserializationException de) {
            logger.error("Error writing cell visibility statement.", (Throwable)de);
            throw new IOException(de);
        }
        return retVal;
    }

    public void put(String tableName, Collection<PutFlowFile> puts) throws IOException {
        try (Table table = this.connection.getTable(TableName.valueOf((String)tableName));){
            HashMap<String, List> sorted = new HashMap<String, List>();
            ArrayList<Put> newPuts = new ArrayList<Put>();
            for (PutFlowFile putFlowFile : puts) {
                String rowKeyString = new String(putFlowFile.getRow(), StandardCharsets.UTF_8);
                List columns = sorted.computeIfAbsent(rowKeyString, k -> new ArrayList());
                columns.addAll(putFlowFile.getColumns());
            }
            for (Map.Entry entry : sorted.entrySet()) {
                newPuts.addAll(this.buildPuts(((String)entry.getKey()).getBytes(StandardCharsets.UTF_8), (List)entry.getValue()));
            }
            table.put(newPuts);
        }
    }

    public void put(String tableName, byte[] rowId, Collection<PutColumn> columns) throws IOException {
        try (Table table = this.connection.getTable(TableName.valueOf((String)tableName));){
            table.put(this.buildPuts(rowId, new ArrayList<PutColumn>(columns)));
        }
    }

    public boolean checkAndPut(String tableName, byte[] rowId, byte[] family, byte[] qualifier, byte[] value, PutColumn column) throws IOException {
        try (Table table = this.connection.getTable(TableName.valueOf((String)tableName));){
            Put put = new Put(rowId);
            put.addColumn(column.getColumnFamily(), column.getColumnQualifier(), column.getBuffer());
            boolean bl = table.checkAndPut(rowId, family, qualifier, value, put);
            return bl;
        }
    }

    public void delete(String tableName, byte[] rowId) throws IOException {
        this.delete(tableName, rowId, null);
    }

    public void delete(String tableName, byte[] rowId, String visibilityLabel) throws IOException {
        try (Table table = this.connection.getTable(TableName.valueOf((String)tableName));){
            Delete delete = new Delete(rowId);
            if (!StringUtils.isEmpty((CharSequence)visibilityLabel)) {
                delete.setCellVisibility(new CellVisibility(visibilityLabel));
            }
            table.delete(delete);
        }
    }

    public void delete(String tableName, List<byte[]> rowIds) throws IOException {
        this.delete(tableName, rowIds, null);
    }

    public void deleteCells(String tableName, List<DeleteRequest> deletes) throws IOException {
        ArrayList<Delete> deleteRequests = new ArrayList<Delete>();
        for (DeleteRequest req : deletes) {
            Delete delete = new Delete(req.getRowId()).addColumn(req.getColumnFamily(), req.getColumnQualifier());
            if (!StringUtils.isEmpty((CharSequence)req.getVisibilityLabel())) {
                delete.setCellVisibility(new CellVisibility(req.getVisibilityLabel()));
            }
            deleteRequests.add(delete);
        }
        this.batchDelete(tableName, deleteRequests);
    }

    public void delete(String tableName, List<byte[]> rowIds, String visibilityLabel) throws IOException {
        ArrayList<Delete> deletes = new ArrayList<Delete>();
        for (byte[] rowId : rowIds) {
            Delete delete = new Delete(rowId);
            if (!StringUtils.isBlank((CharSequence)visibilityLabel)) {
                delete.setCellVisibility(new CellVisibility(visibilityLabel));
            }
            deletes.add(delete);
        }
        this.batchDelete(tableName, deletes);
    }

    private void batchDelete(String tableName, List<Delete> deletes) throws IOException {
        try (Table table = this.connection.getTable(TableName.valueOf((String)tableName));){
            table.delete(deletes);
        }
    }

    public void scan(String tableName, Collection<Column> columns, String filterExpression, long minTime, ResultHandler handler) throws IOException {
        this.scan(tableName, columns, filterExpression, minTime, null, handler);
    }

    public void scan(String tableName, Collection<Column> columns, String filterExpression, long minTime, List<String> visibilityLabels, ResultHandler handler) throws IOException {
        Filter filter = null;
        if (!StringUtils.isBlank((CharSequence)filterExpression)) {
            ParseFilter parseFilter = new ParseFilter();
            filter = parseFilter.parseFilterString(filterExpression);
        }
        try (Table table = this.connection.getTable(TableName.valueOf((String)tableName));
             ResultScanner scanner = this.getResults(table, columns, filter, minTime, visibilityLabels);){
            for (Result result : scanner) {
                byte[] rowKey = result.getRow();
                Cell[] cells = result.rawCells();
                if (cells == null) continue;
                ResultCell[] resultCells = new ResultCell[cells.length];
                for (int i = 0; i < cells.length; ++i) {
                    ResultCell resultCell;
                    Cell cell = cells[i];
                    resultCells[i] = resultCell = this.getResultCell(cell);
                }
                handler.handle(rowKey, resultCells);
            }
        }
    }

    public void scan(String tableName, byte[] startRow, byte[] endRow, Collection<Column> columns, List<String> authorizations, ResultHandler handler) throws IOException {
        try (Table table = this.connection.getTable(TableName.valueOf((String)tableName));
             ResultScanner scanner = this.getResults(table, startRow, endRow, columns, authorizations);){
            for (Result result : scanner) {
                byte[] rowKey = result.getRow();
                Cell[] cells = result.rawCells();
                if (cells == null) continue;
                ResultCell[] resultCells = new ResultCell[cells.length];
                for (int i = 0; i < cells.length; ++i) {
                    ResultCell resultCell;
                    Cell cell = cells[i];
                    resultCells[i] = resultCell = this.getResultCell(cell);
                }
                handler.handle(rowKey, resultCells);
            }
        }
    }

    public void scan(String tableName, String startRow, String endRow, String filterExpression, Long timerangeMin, Long timerangeMax, Integer limitRows, Boolean isReversed, Boolean blockCache, Collection<Column> columns, List<String> visibilityLabels, ResultHandler handler) throws IOException {
        try (Table table = this.connection.getTable(TableName.valueOf((String)tableName));
             ResultScanner scanner = this.getResults(table, startRow, endRow, filterExpression, timerangeMin, timerangeMax, limitRows, isReversed, blockCache, columns, visibilityLabels);){
            int cnt = 0;
            int lim = limitRows != null ? limitRows : 0;
            for (Result result : scanner) {
                if (lim > 0 && ++cnt > lim) {
                    break;
                }
                byte[] rowKey = result.getRow();
                Cell[] cells = result.rawCells();
                if (cells == null) continue;
                ResultCell[] resultCells = new ResultCell[cells.length];
                for (int i = 0; i < cells.length; ++i) {
                    ResultCell resultCell;
                    Cell cell = cells[i];
                    resultCells[i] = resultCell = this.getResultCell(cell);
                }
                handler.handle(rowKey, resultCells);
            }
        }
    }

    protected ResultScanner getResults(Table table, String startRow, String endRow, String filterExpression, Long timerangeMin, Long timerangeMax, Integer limitRows, Boolean isReversed, Boolean blockCache, Collection<Column> columns, List<String> authorizations) throws IOException {
        Scan scan = new Scan();
        if (!StringUtils.isBlank((CharSequence)startRow)) {
            scan.withStartRow(startRow.getBytes(StandardCharsets.UTF_8));
        }
        if (!StringUtils.isBlank((CharSequence)endRow)) {
            scan.withStopRow(endRow.getBytes(StandardCharsets.UTF_8));
        }
        if (authorizations != null && authorizations.size() > 0) {
            scan.setAuthorizations(new Authorizations(authorizations));
        }
        Filter filter = null;
        if (columns != null) {
            for (Column col : columns) {
                if (col.getQualifier() == null) {
                    scan.addFamily(col.getFamily());
                    continue;
                }
                scan.addColumn(col.getFamily(), col.getQualifier());
            }
        }
        if (!StringUtils.isBlank((CharSequence)filterExpression)) {
            ParseFilter parseFilter = new ParseFilter();
            filter = parseFilter.parseFilterString(filterExpression);
        }
        if (filter != null) {
            scan.setFilter(filter);
        }
        if (timerangeMin != null && timerangeMax != null) {
            scan.setTimeRange(timerangeMin.longValue(), timerangeMax.longValue());
        }
        if (isReversed != null) {
            scan.setReversed(isReversed.booleanValue());
        }
        scan.setCacheBlocks(blockCache.booleanValue());
        return table.getScanner(scan);
    }

    protected ResultScanner getResults(Table table, byte[] startRow, byte[] endRow, Collection<Column> columns, List<String> authorizations) throws IOException {
        Scan scan = new Scan();
        scan.withStartRow(startRow);
        scan.withStopRow(endRow);
        if (authorizations != null && authorizations.size() > 0) {
            scan.setAuthorizations(new Authorizations(authorizations));
        }
        if (columns != null && columns.size() > 0) {
            for (Column col : columns) {
                if (col.getQualifier() == null) {
                    scan.addFamily(col.getFamily());
                    continue;
                }
                scan.addColumn(col.getFamily(), col.getQualifier());
            }
        }
        return table.getScanner(scan);
    }

    protected ResultScanner getResults(Table table, Collection<Column> columns, Filter filter, long minTime, List<String> authorizations) throws IOException {
        Scan scan = new Scan();
        scan.setTimeRange(minTime, Long.MAX_VALUE);
        if (authorizations != null && authorizations.size() > 0) {
            scan.setAuthorizations(new Authorizations(authorizations));
        }
        if (filter != null) {
            scan.setFilter(filter);
        }
        if (columns != null) {
            for (Column col : columns) {
                if (col.getQualifier() == null) {
                    scan.addFamily(col.getFamily());
                    continue;
                }
                scan.addColumn(col.getFamily(), col.getQualifier());
            }
        }
        return table.getScanner(scan);
    }

    private ResultCell getResultCell(Cell cell) {
        ResultCell resultCell = new ResultCell();
        resultCell.setRowArray(cell.getRowArray());
        resultCell.setRowOffset(cell.getRowOffset());
        resultCell.setRowLength(cell.getRowLength());
        resultCell.setFamilyArray(cell.getFamilyArray());
        resultCell.setFamilyOffset(cell.getFamilyOffset());
        resultCell.setFamilyLength(cell.getFamilyLength());
        resultCell.setQualifierArray(cell.getQualifierArray());
        resultCell.setQualifierOffset(cell.getQualifierOffset());
        resultCell.setQualifierLength(cell.getQualifierLength());
        resultCell.setTimestamp(cell.getTimestamp());
        resultCell.setTypeByte(cell.getTypeByte());
        resultCell.setSequenceId(cell.getSequenceId());
        resultCell.setValueArray(cell.getValueArray());
        resultCell.setValueOffset(cell.getValueOffset());
        resultCell.setValueLength(cell.getValueLength());
        resultCell.setTagsArray(cell.getTagsArray());
        resultCell.setTagsOffset(cell.getTagsOffset());
        resultCell.setTagsLength(cell.getTagsLength());
        return resultCell;
    }

    public byte[] toBytes(boolean b) {
        return Bytes.toBytes((boolean)b);
    }

    public byte[] toBytes(float f) {
        return Bytes.toBytes((float)f);
    }

    public byte[] toBytes(int i) {
        return Bytes.toBytes((int)i);
    }

    public byte[] toBytes(long l) {
        return Bytes.toBytes((long)l);
    }

    public byte[] toBytes(double d) {
        return Bytes.toBytes((double)d);
    }

    public byte[] toBytes(String s) {
        return Bytes.toBytes((String)s);
    }

    public byte[] toBytesBinary(String s) {
        return Bytes.toBytesBinary((String)s);
    }

    public String toTransitUri(String tableName, String rowKey) {
        if (this.connection == null) {
            logger.warn("Connection has not been established, could not create a transit URI. Returning null.");
            return null;
        }
        String transitUriMasterAddress = StringUtils.isEmpty((CharSequence)this.masterAddress) ? "unknown" : this.masterAddress;
        return "hbase://" + transitUriMasterAddress + "/" + tableName + (String)(StringUtils.isEmpty((CharSequence)rowKey) ? "" : "/" + rowKey);
    }
}

