/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.hazelcast.services.cachemanager;

import com.hazelcast.client.HazelcastClient;
import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.map.IMap;
import java.net.BindException;
import java.util.List;
import org.apache.nifi.annotation.lifecycle.OnDisabled;
import org.apache.nifi.annotation.lifecycle.OnEnabled;
import org.apache.nifi.annotation.lifecycle.OnShutdown;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.controller.AbstractControllerService;
import org.apache.nifi.controller.ConfigurationContext;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.hazelcast.services.cache.HazelcastCache;
import org.apache.nifi.hazelcast.services.cache.IMapBasedHazelcastCache;
import org.apache.nifi.hazelcast.services.cachemanager.HazelcastCacheManager;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.reporting.InitializationException;

abstract class IMapBasedHazelcastCacheManager
extends AbstractControllerService
implements HazelcastCacheManager {
    protected static final String ADDRESS_SEPARATOR = ",";
    protected static final double CLIENT_BACKOFF_JITTER = 0.2;
    protected static final long DEFAULT_CLIENT_TIMEOUT_MAXIMUM_IN_SEC = 20L;
    protected static final long DEFAULT_CLIENT_BACKOFF_INITIAL_IN_SEC = 1L;
    protected static final long DEFAULT_CLIENT_BACKOFF_MAXIMUM_IN_SEC = 5L;
    protected static final double DEFAULT_CLIENT_BACKOFF_MULTIPLIER = 1.5;
    public static final PropertyDescriptor HAZELCAST_CLUSTER_NAME = new PropertyDescriptor.Builder().name("hazelcast-cluster-name").displayName("Hazelcast Cluster Name").description("Name of the Hazelcast cluster.").defaultValue("nifi").required(true).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).build();
    private volatile HazelcastInstance instance;

    IMapBasedHazelcastCacheManager() {
    }

    public HazelcastCache getCache(String name, long ttlInMillis) {
        return new IMapBasedHazelcastCache((IMap<String, byte[]>)this.instance.getMap(name), ttlInMillis);
    }

    @OnEnabled
    public void onEnabled(ConfigurationContext context) throws InitializationException {
        try {
            this.instance = this.getInstance(context);
        }
        catch (Exception e) {
            this.getLogger().error("Could not create Hazelcast instance. Reason: " + e.getMessage(), (Throwable)e);
            if (e.getCause() instanceof BindException && e.getCause().getMessage().equals("Address already in use")) {
                throw new InitializationException("The given port is already in use, probably by an externally running Hazelcast instance!");
            }
            throw new InitializationException((Throwable)e);
        }
    }

    @OnShutdown
    @OnDisabled
    public void shutdown() {
        if (this.instance != null) {
            this.instance.shutdown();
            this.instance = null;
        }
    }

    protected HazelcastInstance getClientInstance(String clusterName, List<String> serverAddresses, long maxTimeout, int initialBackoff, int maxBackoff, double backoffMultiplier) {
        ClientConfig clientConfig = new ClientConfig();
        clientConfig.setClusterName(clusterName);
        clientConfig.getNetworkConfig().setAddresses(serverAddresses);
        clientConfig.getConnectionStrategyConfig().getConnectionRetryConfig().setClusterConnectTimeoutMillis(maxTimeout).setInitialBackoffMillis(initialBackoff).setMaxBackoffMillis(maxBackoff).setMultiplier(backoffMultiplier).setJitter(0.2);
        return HazelcastClient.newHazelcastClient((ClientConfig)clientConfig);
    }

    protected abstract HazelcastInstance getInstance(ConfigurationContext var1);
}

