/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.hazelcast.services.cachemanager;

import com.hazelcast.config.Config;
import com.hazelcast.config.NetworkConfig;
import com.hazelcast.config.TcpIpConfig;
import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.HazelcastInstance;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.components.AllowableValue;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.context.PropertyContext;
import org.apache.nifi.controller.ConfigurationContext;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.hazelcast.services.cachemanager.IMapBasedHazelcastCacheManager;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.util.StandardValidators;

@Tags(value={"hazelcast", "cache"})
@CapabilityDescription(value="A service that runs embedded Hazelcast and provides cache instances backed by that. The server does not ask for authentication, it is recommended to run it within secured network.")
public class EmbeddedHazelcastCacheManager
extends IMapBasedHazelcastCacheManager {
    private static final int DEFAULT_HAZELCAST_PORT = 5701;
    private static final String PORT_SEPARATOR = ":";
    private static final String INSTANCE_CREATION_LOG = "Embedded Hazelcast server instance with instance name %s has been created successfully";
    private static final String MEMBER_LIST_LOG = "Hazelcast cluster will be created based on the NiFi cluster with the following members: %s";
    private static final AllowableValue CLUSTER_NONE = new AllowableValue("none", "None", "No high availability or data replication is provided, every node has access only to the data stored locally.");
    private static final AllowableValue CLUSTER_ALL_NODES = new AllowableValue("all_nodes", "All Nodes", "Creates Hazelcast cluster based on the NiFi cluster: It expects every NiFi nodes to have a running Hazelcast instance on the same port as specified in the Hazelcast Port property. No explicit listing of the instances is needed.");
    private static final AllowableValue CLUSTER_EXPLICIT = new AllowableValue("explicit", "Explicit", "Works with an explicit list of Hazelcast instances, creating a cluster using the listed instances. This provides greater control, making it possible to utilize only certain nodes as Hazelcast servers. The list of Hazelcast instances can be set in the property \"Hazelcast Instances\". The list items must refer to hosts within the NiFi cluster, no external Hazelcast is allowed. NiFi nodes are not listed will be join to the Hazelcast cluster as clients.");
    private static final PropertyDescriptor HAZELCAST_PORT = new PropertyDescriptor.Builder().name("hazelcast-port").displayName("Hazelcast Port").description("Port for the Hazelcast instance to use.").required(true).defaultValue(String.valueOf(5701)).addValidator(StandardValidators.PORT_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).build();
    private static final PropertyDescriptor HAZELCAST_CLUSTERING_STRATEGY = new PropertyDescriptor.Builder().name("hazelcast-clustering-strategy").displayName("Hazelcast Clustering Strategy").description("Specifies with what strategy the Hazelcast cluster should be created.").required(true).allowableValues(new AllowableValue[]{CLUSTER_NONE, CLUSTER_ALL_NODES, CLUSTER_EXPLICIT}).defaultValue(CLUSTER_NONE.getValue()).build();
    private static final PropertyDescriptor HAZELCAST_INSTANCES = new PropertyDescriptor.Builder().name("hazelcast-instances").displayName("Hazelcast Instances").description("Only used with \"Explicit\" Clustering Strategy! List of NiFi instance host names which should be part of the Hazelcast cluster. Host names are separated by comma. The port specified in the \"Hazelcast Port\" property will be used as server port. The list must contain every instance that will be part of the cluster. Other instances will join the Hazelcast cluster as clients.").required(false).addValidator(StandardValidators.URI_LIST_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).build();
    private static final List<PropertyDescriptor> PROPERTY_DESCRIPTORS = Collections.unmodifiableList(Arrays.asList(HAZELCAST_CLUSTER_NAME, HAZELCAST_PORT, HAZELCAST_CLUSTERING_STRATEGY, HAZELCAST_INSTANCES));

    @Override
    protected HazelcastInstance getInstance(ConfigurationContext context) {
        HazelcastInstance result;
        String instanceName = UUID.randomUUID().toString();
        Config config = new Config(instanceName);
        NetworkConfig networkConfig = config.getNetworkConfig();
        TcpIpConfig tcpIpConfig = networkConfig.getJoin().getTcpIpConfig();
        String clusteringStrategy = context.getProperty(HAZELCAST_CLUSTERING_STRATEGY).getValue();
        String clusterName = context.getProperty(HAZELCAST_CLUSTER_NAME).evaluateAttributeExpressions().getValue();
        int port = context.getProperty(HAZELCAST_PORT).evaluateAttributeExpressions().asInteger();
        config.setClusterName(clusterName);
        tcpIpConfig.setEnabled(!clusteringStrategy.equals(CLUSTER_NONE.getValue()));
        networkConfig.setPort(port);
        networkConfig.setPortCount(1);
        networkConfig.setPortAutoIncrement(false);
        networkConfig.getJoin().getMulticastConfig().setEnabled(false);
        if (clusteringStrategy.equals(CLUSTER_ALL_NODES.getValue())) {
            List hazelcastMembers = this.getNodeTypeProvider().getClusterMembers().stream().map(m -> m + PORT_SEPARATOR + port).collect(Collectors.toList());
            this.getLogger().info(String.format(MEMBER_LIST_LOG, hazelcastMembers.stream().collect(Collectors.joining(", "))));
            tcpIpConfig.setMembers(hazelcastMembers);
            result = Hazelcast.newHazelcastInstance((Config)config);
            this.getLogger().info(String.format(INSTANCE_CREATION_LOG, instanceName));
        } else if (clusteringStrategy.equals(CLUSTER_EXPLICIT.getValue())) {
            List<String> hazelcastMembers = this.getHazelcastMemberHosts((PropertyContext)context);
            if (hazelcastMembers.contains(this.getNodeTypeProvider().getCurrentNode().get())) {
                tcpIpConfig.setMembers(hazelcastMembers.stream().map(m -> m + PORT_SEPARATOR + port).collect(Collectors.toList()));
                result = Hazelcast.newHazelcastInstance((Config)config);
                this.getLogger().info(String.format(INSTANCE_CREATION_LOG, instanceName));
            } else {
                result = this.getClientInstance(clusterName, hazelcastMembers.stream().map(m -> m + PORT_SEPARATOR + port).collect(Collectors.toList()), TimeUnit.SECONDS.toMillis(20L), Long.valueOf(TimeUnit.SECONDS.toMillis(1L)).intValue(), Long.valueOf(TimeUnit.SECONDS.toMillis(5L)).intValue(), 1.5);
                this.getLogger().info("This host was not part of the expected Hazelcast instances. Hazelcast client has been started and joined to listed instances.");
            }
        } else if (clusteringStrategy.equals(CLUSTER_NONE.getValue())) {
            result = Hazelcast.newHazelcastInstance((Config)config);
            this.getLogger().info(String.format(INSTANCE_CREATION_LOG, instanceName));
        } else {
            throw new ProcessException("Unknown Hazelcast Clustering Strategy!");
        }
        return result;
    }

    private List<String> getHazelcastMemberHosts(PropertyContext context) {
        return Arrays.asList(context.getProperty(HAZELCAST_INSTANCES).evaluateAttributeExpressions().getValue().split(",")).stream().map(i -> i.trim()).collect(Collectors.toList());
    }

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return PROPERTY_DESCRIPTORS;
    }

    protected Collection<ValidationResult> customValidate(ValidationContext context) {
        LinkedList<ValidationResult> results = new LinkedList<ValidationResult>();
        if (!this.getNodeTypeProvider().isClustered() && context.getProperty(HAZELCAST_CLUSTERING_STRATEGY).getValue().equals(CLUSTER_ALL_NODES.getValue())) {
            results.add(new ValidationResult.Builder().subject(HAZELCAST_CLUSTERING_STRATEGY.getDisplayName()).valid(false).explanation("cannot use \"" + CLUSTER_ALL_NODES.getDisplayName() + "\" Clustering Strategy when NiFi is not part of a cluster!").build());
        }
        if (!this.getNodeTypeProvider().isClustered() && context.getProperty(HAZELCAST_CLUSTERING_STRATEGY).getValue().equals(CLUSTER_EXPLICIT.getValue())) {
            results.add(new ValidationResult.Builder().subject(HAZELCAST_CLUSTERING_STRATEGY.getDisplayName()).valid(false).explanation("cannot use \"" + CLUSTER_EXPLICIT.getDisplayName() + "\" Clustering Strategy when NiFi is not part of a cluster!").build());
        }
        if (!context.getProperty(HAZELCAST_INSTANCES).isSet() && context.getProperty(HAZELCAST_CLUSTERING_STRATEGY).getValue().equals(CLUSTER_EXPLICIT.getValue())) {
            results.add(new ValidationResult.Builder().subject(HAZELCAST_INSTANCES.getDisplayName()).valid(false).explanation("in case of \"" + CLUSTER_EXPLICIT.getDisplayName() + "\" Clustering Strategy, instances need to be specified!").build());
        }
        if (context.getProperty(HAZELCAST_INSTANCES).isSet() && !context.getProperty(HAZELCAST_CLUSTERING_STRATEGY).getValue().equals(CLUSTER_EXPLICIT.getValue())) {
            results.add(new ValidationResult.Builder().subject(HAZELCAST_INSTANCES.getDisplayName()).valid(false).explanation("in case of other Clustering Strategy than \"" + CLUSTER_EXPLICIT.getDisplayName() + "\", instances should not be specified!").build());
        }
        if (context.getProperty(HAZELCAST_INSTANCES).isSet() && context.getProperty(HAZELCAST_CLUSTERING_STRATEGY).getValue().equals(CLUSTER_EXPLICIT.getValue())) {
            Set niFiHosts = this.getNodeTypeProvider().getClusterMembers();
            List<String> hazelcastHosts = this.getHazelcastMemberHosts((PropertyContext)context);
            for (String hazelcastHost : hazelcastHosts) {
                if (niFiHosts.contains(hazelcastHost)) continue;
                results.add(new ValidationResult.Builder().subject(HAZELCAST_INSTANCES.getDisplayName()).valid(false).explanation("host \"" + hazelcastHost + "\" is not part of the NiFi cluster!").build());
            }
        }
        if (!this.getNodeTypeProvider().getCurrentNode().isPresent() && context.getProperty(HAZELCAST_CLUSTERING_STRATEGY).getValue().equals(CLUSTER_EXPLICIT.getValue())) {
            results.add(new ValidationResult.Builder().subject(HAZELCAST_CLUSTERING_STRATEGY.getDisplayName()).valid(false).explanation("cannot determine current node's host!").build());
        }
        return results;
    }
}

