/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.hadoop;

import java.io.IOException;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.stream.Collectors;
import javax.security.auth.Subject;
import javax.security.auth.kerberos.KerberosPrincipal;
import org.apache.commons.lang3.Validate;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.security.krb.KerberosLoginException;
import org.apache.nifi.security.krb.KerberosUser;

public class SecurityUtil {
    public static final String HADOOP_SECURITY_AUTHENTICATION = "hadoop.security.authentication";
    public static final String KERBEROS = "kerberos";

    public static synchronized UserGroupInformation loginKerberos(Configuration config, String principal, String keyTab) throws IOException {
        Validate.notNull((Object)config);
        Validate.notNull((Object)principal);
        Validate.notNull((Object)keyTab);
        UserGroupInformation.setConfiguration((Configuration)config);
        UserGroupInformation.loginUserFromKeytab((String)principal.trim(), (String)keyTab.trim());
        return UserGroupInformation.getCurrentUser();
    }

    public static synchronized UserGroupInformation getUgiForKerberosUser(Configuration config, KerberosUser kerberosUser) throws IOException {
        UserGroupInformation.setConfiguration((Configuration)config);
        try {
            if (kerberosUser.isLoggedIn()) {
                kerberosUser.checkTGTAndRelogin();
            } else {
                kerberosUser.login();
            }
            return (UserGroupInformation)kerberosUser.doAs(() -> {
                AccessControlContext context = AccessController.getContext();
                Subject subject = Subject.getSubject(context);
                Validate.notEmpty(subject.getPrincipals(KerberosPrincipal.class).stream().filter(p -> p.getName().startsWith(kerberosUser.getPrincipal())).collect(Collectors.toSet()), (String)"No Subject was found matching the given principal", (Object[])new Object[0]);
                UserGroupInformation ugi = UserGroupInformation.getUGIFromSubject((Subject)subject);
                UserGroupInformation.setLoginUser((UserGroupInformation)ugi);
                return ugi;
            });
        }
        catch (PrivilegedActionException e) {
            throw new IOException("Unable to acquire UGI for KerberosUser: " + e.getException().getLocalizedMessage(), e.getException());
        }
        catch (KerberosLoginException e) {
            throw new IOException("Unable to acquire UGI for KerberosUser: " + e.getLocalizedMessage(), e);
        }
    }

    public static synchronized UserGroupInformation loginSimple(Configuration config) throws IOException {
        Validate.notNull((Object)config);
        UserGroupInformation.setConfiguration((Configuration)config);
        return UserGroupInformation.getLoginUser();
    }

    public static boolean isSecurityEnabled(Configuration config) {
        Validate.notNull((Object)config);
        return KERBEROS.equalsIgnoreCase(config.get(HADOOP_SECURITY_AUTHENTICATION));
    }

    public static <T> T callWithUgi(UserGroupInformation ugi, PrivilegedExceptionAction<T> action) throws IOException {
        try {
            Object result;
            if (ugi == null) {
                try {
                    result = action.run();
                }
                catch (IOException ioe) {
                    throw ioe;
                }
                catch (RuntimeException re) {
                    throw re;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            } else {
                result = ugi.doAs(action);
            }
            return result;
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
    }

    public static void checkTGTAndRelogin(ComponentLog log, KerberosUser kerberosUser) {
        if (kerberosUser == null) {
            log.debug("kerberosUser was null, will not refresh TGT with KerberosUser");
            return;
        }
        log.debug("checking TGT on kerberosUser {}", new Object[]{kerberosUser});
        kerberosUser.checkTGTAndRelogin();
    }
}

