/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.org.h2.mvstore.tx;

import org.apache.nifi.org.h2.mvstore.MVMap;
import org.apache.nifi.org.h2.mvstore.tx.TransactionStore;
import org.apache.nifi.org.h2.mvstore.tx.VersionedValueCommitted;
import org.apache.nifi.org.h2.value.VersionedValue;

final class CommitDecisionMaker
extends MVMap.DecisionMaker<VersionedValue> {
    private long undoKey;
    private MVMap.Decision decision;

    CommitDecisionMaker() {
    }

    void setUndoKey(long l) {
        this.undoKey = l;
        this.reset();
    }

    @Override
    public MVMap.Decision decide(VersionedValue versionedValue, VersionedValue versionedValue2) {
        assert (this.decision == null);
        this.decision = versionedValue == null || versionedValue.getOperationId() != this.undoKey ? MVMap.Decision.ABORT : (versionedValue.getCurrentValue() == null ? MVMap.Decision.REMOVE : MVMap.Decision.PUT);
        return this.decision;
    }

    @Override
    public VersionedValue selectValue(VersionedValue versionedValue, VersionedValue versionedValue2) {
        assert (this.decision == MVMap.Decision.PUT);
        assert (versionedValue != null);
        return VersionedValueCommitted.getInstance(versionedValue.getCurrentValue());
    }

    @Override
    public void reset() {
        this.decision = null;
    }

    public String toString() {
        return "commit " + TransactionStore.getTransactionId(this.undoKey);
    }
}

