/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.org.h2.schema;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.nifi.org.h2.command.ddl.CreateSynonymData;
import org.apache.nifi.org.h2.command.ddl.CreateTableData;
import org.apache.nifi.org.h2.constraint.Constraint;
import org.apache.nifi.org.h2.engine.Database;
import org.apache.nifi.org.h2.engine.DbObject;
import org.apache.nifi.org.h2.engine.DbObjectBase;
import org.apache.nifi.org.h2.engine.DbSettings;
import org.apache.nifi.org.h2.engine.FunctionAlias;
import org.apache.nifi.org.h2.engine.Right;
import org.apache.nifi.org.h2.engine.Session;
import org.apache.nifi.org.h2.engine.SysProperties;
import org.apache.nifi.org.h2.engine.User;
import org.apache.nifi.org.h2.index.Index;
import org.apache.nifi.org.h2.message.DbException;
import org.apache.nifi.org.h2.mvstore.db.MVTableEngine;
import org.apache.nifi.org.h2.pagestore.db.PageStoreTable;
import org.apache.nifi.org.h2.schema.Constant;
import org.apache.nifi.org.h2.schema.SchemaObject;
import org.apache.nifi.org.h2.schema.Sequence;
import org.apache.nifi.org.h2.schema.TriggerObject;
import org.apache.nifi.org.h2.table.Table;
import org.apache.nifi.org.h2.table.TableLink;
import org.apache.nifi.org.h2.table.TableSynonym;
import org.apache.nifi.org.h2.util.StringUtils;
import org.apache.nifi.org.h2.util.Utils;

public class Schema
extends DbObjectBase {
    private User owner;
    private final boolean system;
    private ArrayList<String> tableEngineParams;
    private final ConcurrentHashMap<String, Table> tablesAndViews;
    private final ConcurrentHashMap<String, TableSynonym> synonyms;
    private final ConcurrentHashMap<String, Index> indexes;
    private final ConcurrentHashMap<String, Sequence> sequences;
    private final ConcurrentHashMap<String, TriggerObject> triggers;
    private final ConcurrentHashMap<String, Constraint> constraints;
    private final ConcurrentHashMap<String, Constant> constants;
    private final ConcurrentHashMap<String, FunctionAlias> functions;
    private final HashSet<String> temporaryUniqueNames = new HashSet();

    public Schema(Database database, int n, String string, User user, boolean bl) {
        super(database, n, string, 8);
        this.tablesAndViews = database.newConcurrentStringMap();
        this.synonyms = database.newConcurrentStringMap();
        this.indexes = database.newConcurrentStringMap();
        this.sequences = database.newConcurrentStringMap();
        this.triggers = database.newConcurrentStringMap();
        this.constraints = database.newConcurrentStringMap();
        this.constants = database.newConcurrentStringMap();
        this.functions = database.newConcurrentStringMap();
        this.owner = user;
        this.system = bl;
    }

    public boolean canDrop() {
        return !this.system;
    }

    @Override
    public String getCreateSQLForCopy(Table table, String string) {
        throw DbException.throwInternalError(this.toString());
    }

    @Override
    public String getDropSQL() {
        return null;
    }

    @Override
    public String getCreateSQL() {
        if (this.system) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder("CREATE SCHEMA IF NOT EXISTS ");
        this.getSQL(stringBuilder, true).append(" AUTHORIZATION ");
        this.owner.getSQL(stringBuilder, true);
        return stringBuilder.toString();
    }

    @Override
    public int getType() {
        return 10;
    }

    public boolean isEmpty() {
        return this.tablesAndViews.isEmpty() && this.synonyms.isEmpty() && this.indexes.isEmpty() && this.sequences.isEmpty() && this.triggers.isEmpty() && this.constraints.isEmpty() && this.constants.isEmpty() && this.functions.isEmpty();
    }

    @Override
    public ArrayList<DbObject> getChildren() {
        ArrayList<DbObject> arrayList = Utils.newSmallArrayList();
        ArrayList<Right> arrayList2 = this.database.getAllRights();
        for (Right right : arrayList2) {
            if (right.getGrantedObject() != this) continue;
            arrayList.add(right);
        }
        return arrayList;
    }

    @Override
    public void removeChildrenAndResources(Session session) {
        this.removeChildrenFromMap(session, this.triggers);
        this.removeChildrenFromMap(session, this.constraints);
        boolean bl = true;
        while (!this.tablesAndViews.isEmpty()) {
            boolean bl2 = false;
            for (Table table : this.tablesAndViews.values()) {
                if (table.getName() == null) continue;
                Table table2 = this.database.getDependentTable(table, table);
                if (table2 == null) {
                    this.database.removeSchemaObject(session, table);
                    bl2 = true;
                    continue;
                }
                if (table2.getSchema() != this) {
                    throw DbException.get(90107, table.getSQL(false), table2.getSQL(false));
                }
                if (bl) continue;
                table2.removeColumnExpressionsDependencies(session);
                table2.setModified();
                this.database.updateMeta(session, table2);
            }
            bl = bl2;
        }
        this.removeChildrenFromMap(session, this.indexes);
        this.removeChildrenFromMap(session, this.sequences);
        this.removeChildrenFromMap(session, this.constants);
        this.removeChildrenFromMap(session, this.functions);
        for (Right right : this.database.getAllRights()) {
            if (right.getGrantedObject() != this) continue;
            this.database.removeDatabaseObject(session, right);
        }
        this.database.removeMeta(session, this.getId());
        this.owner = null;
        this.invalidate();
    }

    private void removeChildrenFromMap(Session session, ConcurrentHashMap<String, ? extends SchemaObject> concurrentHashMap) {
        if (!concurrentHashMap.isEmpty()) {
            for (SchemaObject schemaObject : concurrentHashMap.values()) {
                this.database.removeSchemaObject(session, schemaObject);
            }
        }
    }

    @Override
    public void checkRename() {
    }

    public User getOwner() {
        return this.owner;
    }

    public ArrayList<String> getTableEngineParams() {
        return this.tableEngineParams;
    }

    public void setTableEngineParams(ArrayList<String> arrayList) {
        this.tableEngineParams = arrayList;
    }

    private Map<String, SchemaObject> getMap(int n) {
        ConcurrentHashMap<String, SchemaObject> concurrentHashMap;
        switch (n) {
            case 0: {
                concurrentHashMap = this.tablesAndViews;
                break;
            }
            case 15: {
                concurrentHashMap = this.synonyms;
                break;
            }
            case 3: {
                concurrentHashMap = this.sequences;
                break;
            }
            case 1: {
                concurrentHashMap = this.indexes;
                break;
            }
            case 4: {
                concurrentHashMap = this.triggers;
                break;
            }
            case 5: {
                concurrentHashMap = this.constraints;
                break;
            }
            case 11: {
                concurrentHashMap = this.constants;
                break;
            }
            case 9: {
                concurrentHashMap = this.functions;
                break;
            }
            default: {
                throw DbException.throwInternalError("type=" + n);
            }
        }
        return concurrentHashMap;
    }

    public void add(SchemaObject schemaObject) {
        if (schemaObject.getSchema() != this) {
            DbException.throwInternalError("wrong schema");
        }
        String string = schemaObject.getName();
        Map<String, SchemaObject> map = this.getMap(schemaObject.getType());
        if (SysProperties.CHECK && map.get(string) != null) {
            DbException.throwInternalError("object already exists: " + string);
        }
        map.put(string, schemaObject);
        this.freeUniqueName(string);
    }

    public void rename(SchemaObject schemaObject, String string) {
        int n = schemaObject.getType();
        Map<String, SchemaObject> map = this.getMap(n);
        if (SysProperties.CHECK) {
            if (!map.containsKey(schemaObject.getName())) {
                DbException.throwInternalError("not found: " + schemaObject.getName());
            }
            if (schemaObject.getName().equals(string) || map.containsKey(string)) {
                DbException.throwInternalError("object already exists: " + string);
            }
        }
        schemaObject.checkRename();
        map.remove(schemaObject.getName());
        this.freeUniqueName(schemaObject.getName());
        schemaObject.rename(string);
        map.put(string, schemaObject);
        this.freeUniqueName(string);
    }

    public Table findTableOrView(Session session, String string) {
        Table table = this.tablesAndViews.get(string);
        if (table == null && session != null) {
            table = session.findLocalTempTable(string);
        }
        return table;
    }

    public Table resolveTableOrView(Session session, String string) {
        TableSynonym tableSynonym;
        Table table = this.findTableOrView(session, string);
        if (table == null && (tableSynonym = this.synonyms.get(string)) != null) {
            return tableSynonym.getSynonymFor();
        }
        return table;
    }

    public TableSynonym getSynonym(String string) {
        return this.synonyms.get(string);
    }

    public Index findIndex(Session session, String string) {
        Index index = this.indexes.get(string);
        if (index == null) {
            index = session.findLocalTempTableIndex(string);
        }
        return index;
    }

    public TriggerObject findTrigger(String string) {
        return this.triggers.get(string);
    }

    public Sequence findSequence(String string) {
        return this.sequences.get(string);
    }

    public Constraint findConstraint(Session session, String string) {
        Constraint constraint = this.constraints.get(string);
        if (constraint == null) {
            constraint = session.findLocalTempTableConstraint(string);
        }
        return constraint;
    }

    public Constant findConstant(String string) {
        return this.constants.get(string);
    }

    public FunctionAlias findFunction(String string) {
        return this.functions.get(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void freeUniqueName(String string) {
        if (string != null) {
            HashSet<String> hashSet = this.temporaryUniqueNames;
            synchronized (hashSet) {
                this.temporaryUniqueNames.remove(string);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getUniqueName(DbObject dbObject, Map<String, ? extends SchemaObject> map, String string) {
        String string2 = StringUtils.toUpperEnglish(Integer.toHexString(dbObject.getName().hashCode()));
        String string3 = null;
        HashSet<String> hashSet = this.temporaryUniqueNames;
        synchronized (hashSet) {
            int n;
            int n2 = string2.length();
            for (n = 1; n < n2 && (map.containsKey(string3 = string + string2.substring(0, n)) || this.temporaryUniqueNames.contains(string3)); ++n) {
                string3 = null;
            }
            if (string3 == null) {
                string = string + string2 + "_";
                n = 0;
                while (map.containsKey(string3 = string + n) || this.temporaryUniqueNames.contains(string3)) {
                    ++n;
                }
            }
            this.temporaryUniqueNames.add(string3);
        }
        return string3;
    }

    public String getUniqueConstraintName(Session session, Table table) {
        AbstractMap abstractMap = table.isTemporary() && !table.isGlobalTemporary() ? session.getLocalTempTableConstraints() : this.constraints;
        return this.getUniqueName(table, abstractMap, "CONSTRAINT_");
    }

    public String getUniqueIndexName(Session session, Table table, String string) {
        AbstractMap abstractMap = table.isTemporary() && !table.isGlobalTemporary() ? session.getLocalTempTableIndexes() : this.indexes;
        return this.getUniqueName(table, abstractMap, string);
    }

    public Table getTableOrView(Session session, String string) {
        Table table = this.tablesAndViews.get(string);
        if (table == null) {
            if (session != null) {
                table = session.findLocalTempTable(string);
            }
            if (table == null) {
                throw DbException.get(42102, string);
            }
        }
        return table;
    }

    public Index getIndex(String string) {
        Index index = this.indexes.get(string);
        if (index == null) {
            throw DbException.get(42112, string);
        }
        return index;
    }

    public Constraint getConstraint(String string) {
        Constraint constraint = this.constraints.get(string);
        if (constraint == null) {
            throw DbException.get(90057, string);
        }
        return constraint;
    }

    public Constant getConstant(String string) {
        Constant constant = this.constants.get(string);
        if (constant == null) {
            throw DbException.get(90115, string);
        }
        return constant;
    }

    public Sequence getSequence(String string) {
        Sequence sequence = this.sequences.get(string);
        if (sequence == null) {
            throw DbException.get(90036, string);
        }
        return sequence;
    }

    public ArrayList<SchemaObject> getAll(ArrayList<SchemaObject> arrayList) {
        if (arrayList == null) {
            arrayList = Utils.newSmallArrayList();
        }
        arrayList.addAll(this.tablesAndViews.values());
        arrayList.addAll(this.synonyms.values());
        arrayList.addAll(this.sequences.values());
        arrayList.addAll(this.indexes.values());
        arrayList.addAll(this.triggers.values());
        arrayList.addAll(this.constraints.values());
        arrayList.addAll(this.constants.values());
        arrayList.addAll(this.functions.values());
        return arrayList;
    }

    public ArrayList<SchemaObject> getAll(int n, ArrayList<SchemaObject> arrayList) {
        Collection<SchemaObject> collection = this.getMap(n).values();
        if (arrayList != null) {
            arrayList.addAll(collection);
        } else {
            arrayList = new ArrayList<SchemaObject>(collection);
        }
        return arrayList;
    }

    public Collection<Table> getAllTablesAndViews() {
        return this.tablesAndViews.values();
    }

    public Collection<TableSynonym> getAllSynonyms() {
        return this.synonyms.values();
    }

    public Table getTableOrViewByName(String string) {
        return this.tablesAndViews.get(string);
    }

    public void remove(SchemaObject schemaObject) {
        String string = schemaObject.getName();
        Map<String, SchemaObject> map = this.getMap(schemaObject.getType());
        if (map.remove(string) == null) {
            DbException.throwInternalError("not found: " + string);
        }
        this.freeUniqueName(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Table createTable(CreateTableData createTableData) {
        Database database = this.database;
        synchronized (database) {
            if (!createTableData.temporary || createTableData.globalTemporary) {
                this.database.lockMeta(createTableData.session);
            }
            createTableData.schema = this;
            if (createTableData.tableEngine == null) {
                DbSettings dbSettings = this.database.getSettings();
                if (dbSettings.defaultTableEngine != null) {
                    createTableData.tableEngine = dbSettings.defaultTableEngine;
                } else if (dbSettings.mvStore) {
                    createTableData.tableEngine = MVTableEngine.class.getName();
                }
            }
            if (createTableData.tableEngine != null) {
                if (createTableData.tableEngineParams == null) {
                    createTableData.tableEngineParams = this.tableEngineParams;
                }
                return this.database.getTableEngine(createTableData.tableEngine).createTable(createTableData);
            }
            return new PageStoreTable(createTableData);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TableSynonym createSynonym(CreateSynonymData createSynonymData) {
        Database database = this.database;
        synchronized (database) {
            this.database.lockMeta(createSynonymData.session);
            createSynonymData.schema = this;
            return new TableSynonym(createSynonymData);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TableLink createTableLink(int n, String string, String string2, String string3, String string4, String string5, String string6, String string7, boolean bl, boolean bl2) {
        Database database = this.database;
        synchronized (database) {
            return new TableLink(this, n, string, string2, string3, string4, string5, string6, string7, bl, bl2);
        }
    }
}

