/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.org.h2.command.ddl;

import org.apache.nifi.org.h2.command.ddl.SchemaCommand;
import org.apache.nifi.org.h2.command.ddl.SequenceOptions;
import org.apache.nifi.org.h2.engine.Database;
import org.apache.nifi.org.h2.engine.Session;
import org.apache.nifi.org.h2.message.DbException;
import org.apache.nifi.org.h2.schema.Schema;
import org.apache.nifi.org.h2.schema.Sequence;

public class CreateSequence
extends SchemaCommand {
    private String sequenceName;
    private boolean ifNotExists;
    private SequenceOptions options;
    private boolean belongsToTable;

    public CreateSequence(Session session, Schema schema) {
        super(session, schema);
    }

    public void setSequenceName(String string) {
        this.sequenceName = string;
    }

    public void setIfNotExists(boolean bl) {
        this.ifNotExists = bl;
    }

    public void setOptions(SequenceOptions sequenceOptions) {
        this.options = sequenceOptions;
    }

    @Override
    public int update() {
        this.session.commit(true);
        Database database = this.session.getDatabase();
        if (this.getSchema().findSequence(this.sequenceName) != null) {
            if (this.ifNotExists) {
                return 0;
            }
            throw DbException.get(90035, this.sequenceName);
        }
        int n = this.getObjectId();
        Sequence sequence = new Sequence(this.session, this.getSchema(), n, this.sequenceName, this.options, this.belongsToTable);
        database.addSchemaObject(this.session, sequence);
        return 0;
    }

    public void setBelongsToTable(boolean bl) {
        this.belongsToTable = bl;
    }

    @Override
    public int getType() {
        return 29;
    }
}

