/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.org.h2.mvstore.db;

import java.util.AbstractMap;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.nifi.org.h2.command.dml.AllColumnsForPlan;
import org.apache.nifi.org.h2.engine.Database;
import org.apache.nifi.org.h2.engine.Session;
import org.apache.nifi.org.h2.index.BaseIndex;
import org.apache.nifi.org.h2.index.Cursor;
import org.apache.nifi.org.h2.index.IndexType;
import org.apache.nifi.org.h2.message.DbException;
import org.apache.nifi.org.h2.mvstore.MVMap;
import org.apache.nifi.org.h2.mvstore.db.MVIndex;
import org.apache.nifi.org.h2.mvstore.db.MVTable;
import org.apache.nifi.org.h2.mvstore.db.ValueDataType;
import org.apache.nifi.org.h2.mvstore.tx.Transaction;
import org.apache.nifi.org.h2.mvstore.tx.TransactionMap;
import org.apache.nifi.org.h2.result.Row;
import org.apache.nifi.org.h2.result.SearchRow;
import org.apache.nifi.org.h2.result.SortOrder;
import org.apache.nifi.org.h2.table.Column;
import org.apache.nifi.org.h2.table.IndexColumn;
import org.apache.nifi.org.h2.table.TableFilter;
import org.apache.nifi.org.h2.value.Value;
import org.apache.nifi.org.h2.value.ValueArray;
import org.apache.nifi.org.h2.value.ValueLong;
import org.apache.nifi.org.h2.value.ValueNull;
import org.apache.nifi.org.h2.value.VersionedValue;

public class MVPrimaryIndex
extends BaseIndex
implements MVIndex {
    private final MVTable mvTable;
    private final String mapName;
    private final TransactionMap<Value, Value> dataMap;
    private final AtomicLong lastKey = new AtomicLong();
    private int mainIndexColumn = -1;

    public MVPrimaryIndex(Database database, MVTable mVTable, int n, IndexColumn[] indexColumnArray, IndexType indexType) {
        super(mVTable, n, mVTable.getName() + "_DATA", indexColumnArray, indexType);
        this.mvTable = mVTable;
        int[] nArray = new int[indexColumnArray.length];
        for (int i = 0; i < indexColumnArray.length; ++i) {
            nArray[i] = 0;
        }
        ValueDataType valueDataType = new ValueDataType();
        ValueDataType valueDataType2 = new ValueDataType(database, nArray);
        this.mapName = "table." + this.getId();
        assert (database.isStarting() || !database.getStore().getMvStore().getMetaMap().containsKey("name." + this.mapName));
        Transaction transaction = this.mvTable.getTransactionBegin();
        this.dataMap = transaction.openMap(this.mapName, valueDataType, valueDataType2);
        this.dataMap.map.setVolatile(!mVTable.isPersistData() || !indexType.isPersistent());
        transaction.commit();
        Value value = (Value)this.dataMap.map.lastKey();
        this.lastKey.set(value == null ? 0L : value.getLong());
    }

    @Override
    public String getCreateSQL() {
        return null;
    }

    @Override
    public String getPlanSQL() {
        return this.table.getSQL(new StringBuilder(), false).append(".tableScan").toString();
    }

    public void setMainIndexColumn(int n) {
        this.mainIndexColumn = n;
    }

    public int getMainIndexColumn() {
        return this.mainIndexColumn;
    }

    @Override
    public void close(Session session) {
    }

    @Override
    public void add(Session session, Row row) {
        long l;
        Value value;
        if (this.mainIndexColumn == -1) {
            if (row.getKey() == 0L) {
                row.setKey(this.lastKey.incrementAndGet());
            }
        } else {
            long l2 = row.getValue(this.mainIndexColumn).getLong();
            row.setKey(l2);
        }
        if (this.mvTable.getContainsLargeObject()) {
            int n = row.getColumnCount();
            for (int i = 0; i < n; ++i) {
                Value value2 = row.getValue(i);
                value = value2.copy(this.database, this.getId());
                if (value.isLinkedToTable()) {
                    session.removeAtCommitStop(value);
                }
                if (value2 == value) continue;
                row.setValue(i, value);
            }
        }
        TransactionMap<Value, Value> transactionMap = this.getMap(session);
        long l3 = row.getKey();
        value = ValueLong.get(l3);
        try {
            Value value3 = transactionMap.putIfAbsent(value, ValueArray.get(row.getValueList()));
            if (value3 != null) {
                int n = 90131;
                if (transactionMap.getImmediate(value) != null) {
                    n = 23505;
                }
                DbException dbException = DbException.get(n, this.getDuplicatePrimaryKeyMessage(this.mainIndexColumn).append(' ').append(value3).toString());
                dbException.setSource(this);
                throw dbException;
            }
        }
        catch (IllegalStateException illegalStateException) {
            throw this.mvTable.convertException(illegalStateException);
        }
        while (l3 > (l = this.lastKey.get()) && !this.lastKey.compareAndSet(l, l3)) {
        }
    }

    @Override
    public void remove(Session session, Row row) {
        Object object;
        if (this.mvTable.getContainsLargeObject()) {
            int n = row.getColumnCount();
            for (int i = 0; i < n; ++i) {
                object = row.getValue(i);
                if (!((Value)object).isLinkedToTable()) continue;
                session.removeAtCommit((Value)object);
            }
        }
        TransactionMap<Value, Value> transactionMap = this.getMap(session);
        try {
            Value value = transactionMap.remove(ValueLong.get(row.getKey()));
            if (value == null) {
                object = new StringBuilder();
                this.getSQL((StringBuilder)object, false).append(": ").append(row.getKey());
                throw DbException.get(90112, ((StringBuilder)object).toString());
            }
        }
        catch (IllegalStateException illegalStateException) {
            throw this.mvTable.convertException(illegalStateException);
        }
    }

    @Override
    public void update(Session session, Row row, Row row2) {
        Object object;
        long l;
        if (this.mainIndexColumn != -1) {
            l = row2.getValue(this.mainIndexColumn).getLong();
            row2.setKey(l);
        }
        l = row.getKey();
        assert (this.mainIndexColumn != -1 || l != 0L);
        assert (l == row2.getKey()) : l + " != " + row2.getKey();
        if (this.mvTable.getContainsLargeObject()) {
            int n = row.getColumnCount();
            for (int i = 0; i < n; ++i) {
                Value value;
                Value value2;
                object = row.getValue(i);
                if (object == (value2 = row2.getValue(i))) continue;
                if (((Value)object).isLinkedToTable()) {
                    session.removeAtCommit((Value)object);
                }
                if ((value = value2.copy(this.database, this.getId())).isLinkedToTable()) {
                    session.removeAtCommitStop(value);
                }
                if (value2 == value) continue;
                row2.setValue(i, value);
            }
        }
        TransactionMap<Value, Value> transactionMap = this.getMap(session);
        try {
            Value value = transactionMap.put(ValueLong.get(l), ValueArray.get(row2.getValueList()));
            if (value == null) {
                object = new StringBuilder();
                this.getSQL((StringBuilder)object, false).append(": ").append(l);
                throw DbException.get(90112, ((StringBuilder)object).toString());
            }
        }
        catch (IllegalStateException illegalStateException) {
            throw this.mvTable.convertException(illegalStateException);
        }
        if (row2.getKey() > this.lastKey.get()) {
            this.lastKey.set(row2.getKey());
        }
    }

    Row lockRow(Session session, Row row) {
        long l;
        TransactionMap<Value, Value> transactionMap = this.getMap(session);
        ValueArray valueArray = (ValueArray)this.lockRow(transactionMap, l = row.getKey());
        return valueArray == null ? null : MVPrimaryIndex.getRow(session, l, valueArray);
    }

    private Value lockRow(TransactionMap<Value, Value> transactionMap, long l) {
        try {
            return transactionMap.lock(ValueLong.get(l));
        }
        catch (IllegalStateException illegalStateException) {
            throw this.mvTable.convertException(illegalStateException);
        }
    }

    @Override
    public Cursor find(Session session, SearchRow searchRow, SearchRow searchRow2) {
        ValueLong valueLong = searchRow == null ? ValueLong.MIN : ValueLong.get(searchRow.getKey());
        ValueLong valueLong2 = searchRow2 == null ? ValueLong.MAX : ValueLong.get(searchRow2.getKey());
        TransactionMap<Value, Value> transactionMap = this.getMap(session);
        return new MVStoreCursor(session, transactionMap.entryIterator(valueLong, valueLong2));
    }

    @Override
    public MVTable getTable() {
        return this.mvTable;
    }

    @Override
    public Row getRow(Session session, long l) {
        TransactionMap<Value, Value> transactionMap = this.getMap(session);
        Value value = transactionMap.getFromSnapshot(ValueLong.get(l));
        if (value == null) {
            throw DbException.get(90143, this.getSQL(false), String.valueOf(l));
        }
        return MVPrimaryIndex.getRow(session, l, (ValueArray)value);
    }

    private static Row getRow(Session session, long l, ValueArray valueArray) {
        Row row = session.createRow(valueArray.getList(), 0);
        row.setKey(l);
        return row;
    }

    @Override
    public double getCost(Session session, int[] nArray, TableFilter[] tableFilterArray, int n, SortOrder sortOrder, AllColumnsForPlan allColumnsForPlan) {
        try {
            return 10L * this.getCostRangeIndex(nArray, this.dataMap.sizeAsLongMax(), tableFilterArray, n, sortOrder, true, allColumnsForPlan);
        }
        catch (IllegalStateException illegalStateException) {
            throw DbException.get(90007, illegalStateException, new String[0]);
        }
    }

    @Override
    public int getColumnIndex(Column column) {
        return -1;
    }

    @Override
    public boolean isFirstColumn(Column column) {
        return false;
    }

    @Override
    public void remove(Session session) {
        TransactionMap<Value, Value> transactionMap = this.getMap(session);
        if (!transactionMap.isClosed()) {
            Transaction transaction = session.getTransaction();
            transaction.removeMap(transactionMap);
        }
    }

    @Override
    public void truncate(Session session) {
        TransactionMap<Value, Value> transactionMap = this.getMap(session);
        if (this.mvTable.getContainsLargeObject()) {
            this.database.getLobStorage().removeAllForTable(this.table.getId());
        }
        transactionMap.clear();
    }

    @Override
    public boolean canGetFirstOrLast() {
        return true;
    }

    @Override
    public Cursor findFirstOrLast(Session session, boolean bl) {
        TransactionMap<Value, Value> transactionMap = this.getMap(session);
        ValueLong valueLong = (ValueLong)(bl ? transactionMap.firstKey() : transactionMap.lastKey());
        if (valueLong == null) {
            return new MVStoreCursor(session, Collections.emptyIterator());
        }
        Value value = transactionMap.getFromSnapshot(valueLong);
        AbstractMap.SimpleImmutableEntry<ValueLong, Value> simpleImmutableEntry = new AbstractMap.SimpleImmutableEntry<ValueLong, Value>(valueLong, value);
        List<AbstractMap.SimpleImmutableEntry<ValueLong, Value>> list = Collections.singletonList(simpleImmutableEntry);
        MVStoreCursor mVStoreCursor = new MVStoreCursor(session, list.iterator());
        mVStoreCursor.next();
        return mVStoreCursor;
    }

    @Override
    public boolean needRebuild() {
        return false;
    }

    @Override
    public long getRowCount(Session session) {
        TransactionMap<Value, Value> transactionMap = this.getMap(session);
        return transactionMap.sizeAsLong();
    }

    public long getRowCountMax() {
        return this.dataMap.sizeAsLongMax();
    }

    @Override
    public long getRowCountApproximation() {
        return this.getRowCountMax();
    }

    @Override
    public long getDiskSpaceUsed() {
        return this.dataMap.map.getRootPage().getDiskSpaceUsed();
    }

    public String getMapName() {
        return this.mapName;
    }

    @Override
    public void checkRename() {
    }

    @Override
    public void addRowsToBuffer(List<Row> list, String string) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addBufferedRows(List<String> list) {
        throw new UnsupportedOperationException();
    }

    ValueLong getKey(SearchRow searchRow, ValueLong valueLong, ValueLong valueLong2) {
        if (searchRow == null) {
            return valueLong;
        }
        Value value = searchRow.getValue(this.mainIndexColumn);
        if (value == null) {
            throw DbException.throwInternalError(searchRow.toString());
        }
        if (value == ValueNull.INSTANCE) {
            return valueLong2;
        }
        return (ValueLong)value.convertTo(5);
    }

    Cursor find(Session session, ValueLong valueLong, ValueLong valueLong2) {
        TransactionMap<Value, Value> transactionMap = this.getMap(session);
        return new MVStoreCursor(session, transactionMap.entryIterator(valueLong, valueLong2));
    }

    @Override
    public boolean isRowIdIndex() {
        return true;
    }

    TransactionMap<Value, Value> getMap(Session session) {
        if (session == null) {
            return this.dataMap;
        }
        Transaction transaction = session.getTransaction();
        return this.dataMap.getInstance(transaction);
    }

    public MVMap<Value, VersionedValue> getMVMap() {
        return this.dataMap.map;
    }

    static class MVStoreCursor
    implements Cursor {
        private final Session session;
        private final Iterator<Map.Entry<Value, Value>> it;
        private Map.Entry<Value, Value> current;
        private Row row;

        public MVStoreCursor(Session session, Iterator<Map.Entry<Value, Value>> iterator) {
            this.session = session;
            this.it = iterator;
        }

        @Override
        public Row get() {
            if (this.row == null && this.current != null) {
                ValueArray valueArray = (ValueArray)this.current.getValue();
                this.row = this.session.createRow(valueArray.getList(), 0);
                this.row.setKey(this.current.getKey().getLong());
            }
            return this.row;
        }

        @Override
        public SearchRow getSearchRow() {
            return this.get();
        }

        @Override
        public boolean next() {
            this.current = this.it.hasNext() ? this.it.next() : null;
            this.row = null;
            return this.current != null;
        }

        @Override
        public boolean previous() {
            throw DbException.getUnsupportedException("previous");
        }
    }
}

