/*
 * Decompiled with CFR 0.152.
 */
package v14.h2.command.ddl;

import v14.h2.command.ddl.DefineCommand;
import v14.h2.engine.Database;
import v14.h2.engine.Role;
import v14.h2.engine.Session;
import v14.h2.message.DbException;

public class CreateRole
extends DefineCommand {
    private String roleName;
    private boolean ifNotExists;

    public CreateRole(Session session) {
        super(session);
    }

    public void setIfNotExists(boolean bl) {
        this.ifNotExists = bl;
    }

    public void setRoleName(String string) {
        this.roleName = string;
    }

    @Override
    public int update() {
        this.session.getUser().checkAdmin();
        this.session.commit(true);
        Database database = this.session.getDatabase();
        if (database.findUser(this.roleName) != null) {
            throw DbException.get(90033, this.roleName);
        }
        if (database.findRole(this.roleName) != null) {
            if (this.ifNotExists) {
                return 0;
            }
            throw DbException.get(90069, this.roleName);
        }
        int n = this.getObjectId();
        Role role = new Role(database, n, this.roleName, false);
        database.addDatabaseObject(this.session, role);
        return 0;
    }

    @Override
    public int getType() {
        return 27;
    }
}

