/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.groovyx.flow;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import org.apache.nifi.components.state.Scope;
import org.apache.nifi.components.state.StateMap;
import org.apache.nifi.controller.queue.QueueSize;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.processor.FlowFileFilter;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.FlowFileAccessException;
import org.apache.nifi.processor.io.InputStreamCallback;
import org.apache.nifi.processor.io.OutputStreamCallback;
import org.apache.nifi.processor.io.StreamCallback;
import org.apache.nifi.processors.groovyx.flow.SessionFile;
import org.apache.nifi.processors.groovyx.util.Throwables;
import org.apache.nifi.provenance.ProvenanceReporter;

public abstract class ProcessSessionWrap
implements ProcessSession {
    public static final String ERROR_STACKTRACE = "ERROR_STACKTRACE";
    public static final String ERROR_MESSAGE = "ERROR_MESSAGE";
    private ProcessSession session;
    private boolean failureOnError;
    private List<FlowFile> toFail = new ArrayList<FlowFile>();
    private Map<String, FlowFile> toDrop = new HashMap<String, FlowFile>();

    public ProcessSessionWrap(ProcessSession session, boolean toFailureOnError) {
        if (session instanceof ProcessSessionWrap) {
            throw new RuntimeException("session could be instanceof ProcessSessionWrap");
        }
        if (session == null) {
            throw new NullPointerException("Session is mandatory session=null");
        }
        this.session = session;
        this.failureOnError = toFailureOnError;
    }

    public abstract SessionFile wrap(FlowFile var1);

    public List<FlowFile> wrap(List<FlowFile> ff) {
        if (ff == null) {
            return null;
        }
        for (int i = 0; i < ff.size(); ++i) {
            ff.set(i, this.wrap(ff.get(i)));
        }
        return ff;
    }

    public FlowFile unwrap(FlowFile f) {
        if (f == null) {
            return null;
        }
        if (f instanceof SessionFile) {
            return ((SessionFile)f).flowFile;
        }
        return f;
    }

    public List<FlowFile> unwrap(Collection<FlowFile> flowFiles) {
        if (flowFiles == null) {
            return null;
        }
        ArrayList<FlowFile> ff = new ArrayList<FlowFile>(flowFiles);
        for (int i = 0; i < ff.size(); ++i) {
            ff.set(i, this.unwrap((FlowFile)ff.get(i)));
        }
        return ff;
    }

    private void assertNotSessionFile(FlowFile f) {
        if (f instanceof SessionFile) {
            throw new RuntimeException("SessionFile not accepted at this point. " + this.getClass() + " developer failure.");
        }
    }

    private FlowFile onMod(FlowFile f) {
        this.assertNotSessionFile(f);
        if (this.failureOnError) {
            this.toDrop.put(f.getAttribute("uuid"), f);
        }
        return f;
    }

    private FlowFile onGet(FlowFile f) {
        this.assertNotSessionFile(f);
        if (f == null) {
            return null;
        }
        if (this.failureOnError) {
            this.toFail.add(this.session.clone(f));
            this.onMod(f);
        }
        return f;
    }

    private List<FlowFile> onGet(List<FlowFile> ff) {
        if (ff == null) {
            return null;
        }
        if (this.failureOnError) {
            for (FlowFile f : ff) {
                this.onGet(f);
            }
        }
        return ff;
    }

    private void onDrop(FlowFile f) {
        this.assertNotSessionFile(f);
        if (this.failureOnError) {
            this.toDrop.remove(f.getAttribute("uuid"));
        }
    }

    private void onDrop(Collection<FlowFile> ff) {
        if (this.failureOnError) {
            for (FlowFile f : ff) {
                this.onDrop(f);
            }
        }
    }

    private void onClear() {
        if (this.failureOnError) {
            this.toDrop.clear();
            this.toFail.clear();
        }
    }

    public void revertReceivedTo(Relationship r, Throwable t) {
        for (FlowFile f : this.toDrop.values()) {
            this.session.remove(f);
        }
        String errorMessage = Throwables.getMessage(t, null, 950);
        String stackTrace = Throwables.stringStackTrace(t);
        for (FlowFile f : this.toFail) {
            if (t != null && r != null) {
                f = this.session.putAttribute(f, ERROR_MESSAGE, errorMessage);
                f = this.session.putAttribute(f, ERROR_STACKTRACE, stackTrace);
            }
            if (r != null) {
                this.session.transfer(f, r);
                continue;
            }
            f = this.session.penalize(f);
            this.session.transfer(f);
        }
        this.session.commit();
        this.onClear();
    }

    public void commit() {
        this.toFail.forEach(arg_0 -> ((ProcessSession)this.session).remove(arg_0));
        this.session.commit();
        this.onClear();
    }

    public void commitAsync() {
        this.toFail.forEach(arg_0 -> ((ProcessSession)this.session).remove(arg_0));
        this.session.commitAsync(this::onClear);
    }

    public void commitAsync(Runnable onSuccess, Consumer<Throwable> onFailure) {
        this.toFail.forEach(arg_0 -> ((ProcessSession)this.session).remove(arg_0));
        this.session.commitAsync(() -> {
            onSuccess.run();
            this.onClear();
        }, onFailure);
    }

    public void rollback() {
        this.session.rollback();
        this.onClear();
    }

    public void rollback(boolean penalize) {
        this.session.rollback(penalize);
        this.onClear();
    }

    public void adjustCounter(String name, long delta, boolean immediate) {
        this.session.adjustCounter(name, delta, immediate);
    }

    public SessionFile get() {
        return this.wrap(this.onGet(this.session.get()));
    }

    public List<FlowFile> get(int maxResults) {
        return this.wrap(this.onGet(this.session.get(maxResults)));
    }

    public List<FlowFile> get(FlowFileFilter filter) {
        return this.wrap(this.onGet(this.session.get(filter)));
    }

    public QueueSize getQueueSize() {
        return this.session.getQueueSize();
    }

    public SessionFile create() {
        return this.wrap(this.onMod(this.session.create()));
    }

    public SessionFile create(FlowFile parent) {
        return this.wrap(this.onMod(this.session.create(this.unwrap(parent))));
    }

    public SessionFile create(Collection<FlowFile> parents) {
        return this.wrap(this.onMod(this.session.create(this.unwrap(parents))));
    }

    public SessionFile clone(FlowFile example) {
        return this.wrap(this.onMod(this.session.clone(this.unwrap(example))));
    }

    public SessionFile clone(FlowFile parent, long offset, long size) {
        return this.wrap(this.onMod(this.session.clone(this.unwrap(parent), offset, size)));
    }

    public SessionFile penalize(FlowFile flowFile) {
        SessionFile sf = this.wrap(flowFile);
        sf.flowFile = this.onMod(this.session.penalize(sf.flowFile));
        return sf;
    }

    public SessionFile putAttribute(FlowFile flowFile, String key, String value) {
        SessionFile sf = this.wrap(flowFile);
        sf.flowFile = this.onMod(this.session.putAttribute(sf.flowFile, key, value));
        return sf;
    }

    public SessionFile putAllAttributes(FlowFile flowFile, Map<String, String> attributes) {
        SessionFile sf = this.wrap(flowFile);
        sf.flowFile = this.onMod(this.session.putAllAttributes(sf.flowFile, attributes));
        return sf;
    }

    public SessionFile removeAttribute(FlowFile flowFile, String key) {
        SessionFile sf = this.wrap(flowFile);
        sf.flowFile = this.onMod(this.session.removeAttribute(sf.flowFile, key));
        return sf;
    }

    public SessionFile removeAllAttributes(FlowFile flowFile, Set<String> keys) {
        SessionFile sf = this.wrap(flowFile);
        sf.flowFile = this.onMod(this.session.removeAllAttributes(sf.flowFile, keys));
        return sf;
    }

    public SessionFile removeAllAttributes(FlowFile flowFile, Pattern keyPattern) {
        SessionFile sf = this.wrap(flowFile);
        sf.flowFile = this.onMod(this.session.removeAllAttributes(sf.flowFile, keyPattern));
        return sf;
    }

    public void transfer(FlowFile flowFile, Relationship relationship) {
        flowFile = this.unwrap(flowFile);
        this.session.transfer(flowFile, relationship);
    }

    public void transfer(FlowFile flowFile) {
        flowFile = this.unwrap(flowFile);
        this.session.transfer(flowFile);
    }

    public void transfer(Collection<FlowFile> flowFiles) {
        flowFiles = this.unwrap(flowFiles);
        this.session.transfer(flowFiles);
    }

    public void transfer(Collection<FlowFile> flowFiles, Relationship relationship) {
        flowFiles = this.unwrap(flowFiles);
        this.session.transfer(flowFiles, relationship);
    }

    public void remove(FlowFile flowFile) {
        flowFile = this.unwrap(flowFile);
        this.session.remove(flowFile);
        this.onDrop(flowFile);
    }

    public void remove(Collection<FlowFile> flowFiles) {
        flowFiles = this.unwrap(flowFiles);
        this.session.remove(flowFiles);
        this.onDrop(flowFiles);
    }

    public void read(FlowFile flowFile, InputStreamCallback reader) throws FlowFileAccessException {
        flowFile = this.unwrap(flowFile);
        this.session.read(flowFile, reader);
    }

    public InputStream read(FlowFile flowFile) {
        flowFile = this.unwrap(flowFile);
        return this.session.read(flowFile);
    }

    public void read(FlowFile flowFile, boolean allowSessionStreamManagement, InputStreamCallback reader) throws FlowFileAccessException {
        flowFile = this.unwrap(flowFile);
        this.session.read(flowFile, allowSessionStreamManagement, reader);
    }

    public SessionFile merge(Collection<FlowFile> sources, FlowFile destination) {
        SessionFile sfDestination = this.wrap(destination);
        sources = this.unwrap(sources);
        sfDestination.flowFile = this.onMod(this.session.merge(sources, sfDestination.flowFile));
        return sfDestination;
    }

    public SessionFile merge(Collection<FlowFile> sources, FlowFile destination, byte[] header, byte[] footer, byte[] demarcator) {
        SessionFile sfDestination = this.wrap(destination);
        sources = this.unwrap(sources);
        sfDestination.flowFile = this.onMod(this.session.merge(sources, sfDestination.flowFile, header, footer, demarcator));
        return sfDestination;
    }

    public SessionFile write(FlowFile flowFile, OutputStreamCallback writer) throws FlowFileAccessException {
        SessionFile sf = this.wrap(flowFile);
        sf.flowFile = this.onMod(this.session.write(sf.flowFile, writer));
        return sf;
    }

    public SessionFile write(FlowFile flowFile, StreamCallback writer) throws FlowFileAccessException {
        SessionFile sf = this.wrap(flowFile);
        sf.flowFile = this.onMod(this.session.write(sf.flowFile, writer));
        return sf;
    }

    public SessionFile append(FlowFile flowFile, OutputStreamCallback writer) throws FlowFileAccessException {
        SessionFile sf = this.wrap(flowFile);
        sf.flowFile = this.onMod(this.session.append(sf.flowFile, writer));
        return sf;
    }

    public SessionFile importFrom(Path source, boolean keepSourceFile, FlowFile flowFile) {
        SessionFile sf = this.wrap(flowFile);
        sf.flowFile = this.onMod(this.session.importFrom(source, keepSourceFile, sf.flowFile));
        return sf;
    }

    public SessionFile importFrom(InputStream source, FlowFile flowFile) {
        SessionFile sf = this.wrap(flowFile);
        sf.flowFile = this.onMod(this.session.importFrom(source, sf.flowFile));
        return sf;
    }

    public void exportTo(FlowFile flowFile, Path destination, boolean append) {
        flowFile = this.unwrap(flowFile);
        this.session.exportTo(flowFile, destination, append);
    }

    public void exportTo(FlowFile flowFile, OutputStream destination) {
        flowFile = this.unwrap(flowFile);
        this.session.exportTo(flowFile, destination);
    }

    public ProvenanceReporter getProvenanceReporter() {
        return this.session.getProvenanceReporter();
    }

    public void migrate(ProcessSession newOwner) {
        this.session.migrate(newOwner);
    }

    public void migrate(ProcessSession newOwner, Collection<FlowFile> flowFiles) {
        flowFiles = this.unwrap(flowFiles);
        this.session.migrate(newOwner, flowFiles);
    }

    public OutputStream write(FlowFile source) {
        source = this.unwrap(source);
        return this.session.write(source);
    }

    public void setState(Map<String, String> state, Scope scope) throws IOException {
        this.session.setState(state, scope);
    }

    public StateMap getState(Scope scope) throws IOException {
        return this.session.getState(scope);
    }

    public boolean replaceState(StateMap oldValue, Map<String, String> newValue, Scope scope) throws IOException {
        return this.session.replaceState(oldValue, newValue, scope);
    }

    public void clearState(Scope scope) throws IOException {
        this.session.clearState(scope);
    }
}

