/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.gcp.drive;

import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.gson.GsonFactory;
import com.google.api.services.drive.Drive;
import com.google.api.services.drive.model.File;
import com.google.auth.Credentials;
import com.google.auth.http.HttpCredentialsAdapter;
import com.google.auth.oauth2.GoogleCredentials;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.nifi.gcp.credentials.service.GCPCredentialsService;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processors.gcp.drive.GoogleDriveAttributes;
import org.apache.nifi.processors.gcp.util.GoogleUtils;

public interface GoogleDriveTrait {
    public static final String DRIVE_FOLDER_MIME_TYPE = "application/vnd.google-apps.folder";
    public static final String DRIVE_URL = "https://drive.google.com/open?id=";
    public static final String APPLICATION_NAME = "NiFi";
    public static final JsonFactory JSON_FACTORY = GsonFactory.getDefaultInstance();

    default public Drive createDriveService(ProcessContext context, HttpTransport httpTransport, String ... scopes) {
        Drive driveService = new Drive.Builder(httpTransport, JSON_FACTORY, (HttpRequestInitializer)this.getHttpCredentialsAdapter(context, Arrays.asList(scopes))).setApplicationName(APPLICATION_NAME).build();
        return driveService;
    }

    default public HttpCredentialsAdapter getHttpCredentialsAdapter(ProcessContext context, Collection<String> scopes) {
        GoogleCredentials googleCredentials = this.getGoogleCredentials(context);
        HttpCredentialsAdapter httpCredentialsAdapter = new HttpCredentialsAdapter((Credentials)googleCredentials.createScoped(scopes));
        return httpCredentialsAdapter;
    }

    default public GoogleCredentials getGoogleCredentials(ProcessContext context) {
        GCPCredentialsService gcpCredentialsService = (GCPCredentialsService)context.getProperty(GoogleUtils.GCP_CREDENTIALS_PROVIDER_SERVICE).asControllerService(GCPCredentialsService.class);
        return gcpCredentialsService.getGoogleCredentials();
    }

    default public Map<String, String> createAttributeMap(File file) {
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("drive.id", file.getId());
        attributes.put(GoogleDriveAttributes.FILENAME, file.getName());
        attributes.put(GoogleDriveAttributes.MIME_TYPE, file.getMimeType());
        attributes.put("drive.timestamp", String.valueOf(file.getCreatedTime()));
        attributes.put("drive.size", String.valueOf(file.getSize()));
        return attributes;
    }
}

