/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.gcp;

import com.google.auth.http.HttpTransportFactory;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.cloud.Service;
import com.google.cloud.ServiceOptions;
import com.google.cloud.TransportOptions;
import com.google.cloud.http.HttpTransportOptions;
import java.net.Proxy;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.nifi.annotation.lifecycle.OnScheduled;
import org.apache.nifi.components.ConfigVerificationResult;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.context.PropertyContext;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.gcp.credentials.service.GCPCredentialsService;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.processor.AbstractProcessor;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.processors.gcp.ProxyAwareTransportFactory;
import org.apache.nifi.processors.gcp.util.GoogleUtils;
import org.apache.nifi.proxy.ProxyConfiguration;
import org.apache.nifi.proxy.ProxySpec;

public abstract class AbstractGCPProcessor<CloudService extends Service<CloudServiceOptions>, CloudServiceOptions extends ServiceOptions<CloudService, CloudServiceOptions>>
extends AbstractProcessor {
    public static final PropertyDescriptor PROJECT_ID = new PropertyDescriptor.Builder().name("gcp-project-id").displayName("Project ID").description("Google Cloud Project ID").required(false).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final PropertyDescriptor RETRY_COUNT = new PropertyDescriptor.Builder().name("gcp-retry-count").displayName("Number of retries").description("How many retry attempts should be made before routing to the failure relationship.").defaultValue("6").required(true).addValidator(StandardValidators.INTEGER_VALIDATOR).build();
    public static final PropertyDescriptor PROXY_HOST = new PropertyDescriptor.Builder().name("gcp-proxy-host").displayName("Proxy host").description("IP or hostname of the proxy to be used.\n You might need to set the following properties in bootstrap for https proxy usage:\n-Djdk.http.auth.tunneling.disabledSchemes=\n-Djdk.http.auth.proxying.disabledSchemes=").required(false).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final PropertyDescriptor PROXY_PORT = new PropertyDescriptor.Builder().name("gcp-proxy-port").displayName("Proxy port").description("Proxy port number").required(false).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).addValidator(StandardValidators.PORT_VALIDATOR).build();
    public static final PropertyDescriptor HTTP_PROXY_USERNAME = new PropertyDescriptor.Builder().name("gcp-proxy-user-name").displayName("HTTP Proxy Username").description("HTTP Proxy Username").addValidator(StandardValidators.NON_EMPTY_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).required(false).build();
    public static final PropertyDescriptor HTTP_PROXY_PASSWORD = new PropertyDescriptor.Builder().name("gcp-proxy-user-password").displayName("HTTP Proxy Password").description("HTTP Proxy Password").addValidator(StandardValidators.NON_EMPTY_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).required(false).sensitive(true).build();
    @Deprecated
    public static final PropertyDescriptor GCP_CREDENTIALS_PROVIDER_SERVICE = new PropertyDescriptor.Builder().fromPropertyDescriptor(GoogleUtils.GCP_CREDENTIALS_PROVIDER_SERVICE).name("GCP Credentials Provider Service").build();
    protected volatile CloudService cloudService;

    protected CloudService getCloudService() {
        return this.cloudService;
    }

    public List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return Collections.unmodifiableList(Arrays.asList(PROJECT_ID, GCP_CREDENTIALS_PROVIDER_SERVICE, RETRY_COUNT, PROXY_HOST, PROXY_PORT, HTTP_PROXY_USERNAME, HTTP_PROXY_PASSWORD, ProxyConfiguration.createProxyConfigPropertyDescriptor((boolean)true, (ProxySpec[])ProxyAwareTransportFactory.PROXY_SPECS)));
    }

    protected List<ConfigVerificationResult> verifyCloudService(ProcessContext context, ComponentLog verificationLogger, Map<String, String> attributes) {
        ConfigVerificationResult result = null;
        try {
            CloudService cloudService = this.getCloudService(context);
            if (cloudService != null) {
                result = new ConfigVerificationResult.Builder().verificationStepName("Configure Cloud Service").outcome(ConfigVerificationResult.Outcome.SUCCESSFUL).explanation(String.format("Successfully configured Cloud Service [%s]", cloudService.getClass().getSimpleName())).build();
            }
        }
        catch (Exception e) {
            verificationLogger.error("Failed to configure Cloud Service", (Throwable)e);
            result = new ConfigVerificationResult.Builder().verificationStepName("Configure Cloud Service").outcome(ConfigVerificationResult.Outcome.FAILED).explanation(String.format("Failed to configure Cloud Service [%s]: %s", this.cloudService.getClass().getSimpleName(), e.getMessage())).build();
        }
        return result == null ? Collections.emptyList() : Collections.singletonList(result);
    }

    protected GoogleCredentials getGoogleCredentials(ProcessContext context) {
        GCPCredentialsService gcpCredentialsService = (GCPCredentialsService)context.getProperty(GCP_CREDENTIALS_PROVIDER_SERVICE).asControllerService(GCPCredentialsService.class);
        return gcpCredentialsService.getGoogleCredentials();
    }

    protected CloudService getCloudService(ProcessContext context) {
        CloudServiceOptions options = this.getServiceOptions(context, this.getGoogleCredentials(context));
        return (CloudService)(options != null ? options.getService() : null);
    }

    @OnScheduled
    public void onScheduled(ProcessContext context) {
        this.cloudService = this.getCloudService(context);
    }

    protected abstract CloudServiceOptions getServiceOptions(ProcessContext var1, GoogleCredentials var2);

    protected TransportOptions getTransportOptions(ProcessContext context) {
        ProxyConfiguration proxyConfiguration = ProxyConfiguration.getConfiguration((PropertyContext)context, () -> {
            if (context.getProperty(PROXY_HOST).isSet() && context.getProperty(PROXY_PORT).isSet()) {
                String proxyHost = context.getProperty(PROXY_HOST).evaluateAttributeExpressions().getValue();
                Integer proxyPort = context.getProperty(PROXY_PORT).evaluateAttributeExpressions().asInteger();
                if (proxyHost != null && proxyPort != null && proxyPort > 0) {
                    ProxyConfiguration componentProxyConfig = new ProxyConfiguration();
                    String proxyUser = context.getProperty(HTTP_PROXY_USERNAME).evaluateAttributeExpressions().getValue();
                    String proxyPassword = context.getProperty(HTTP_PROXY_PASSWORD).evaluateAttributeExpressions().getValue();
                    componentProxyConfig.setProxyType(Proxy.Type.HTTP);
                    componentProxyConfig.setProxyServerHost(proxyHost);
                    componentProxyConfig.setProxyServerPort(proxyPort);
                    componentProxyConfig.setProxyUserName(proxyUser);
                    componentProxyConfig.setProxyUserPassword(proxyPassword);
                    return componentProxyConfig;
                }
            }
            return ProxyConfiguration.DIRECT_CONFIGURATION;
        });
        ProxyAwareTransportFactory transportFactory = new ProxyAwareTransportFactory(proxyConfiguration);
        return HttpTransportOptions.newBuilder().setHttpTransportFactory((HttpTransportFactory)transportFactory).build();
    }
}

