/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.gcp.bigquery;

import com.google.cloud.RetryOption;
import com.google.cloud.bigquery.BigQuery;
import com.google.cloud.bigquery.FormatOptions;
import com.google.cloud.bigquery.Job;
import com.google.cloud.bigquery.JobInfo;
import com.google.cloud.bigquery.JobStatistics;
import com.google.cloud.bigquery.Schema;
import com.google.cloud.bigquery.TableDataWriteChannel;
import com.google.cloud.bigquery.TableId;
import com.google.cloud.bigquery.WriteChannelConfiguration;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.behavior.WritesAttribute;
import org.apache.nifi.annotation.behavior.WritesAttributes;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.DeprecationNotice;
import org.apache.nifi.annotation.documentation.SeeAlso;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnScheduled;
import org.apache.nifi.components.AllowableValue;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.components.Validator;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.logging.LogLevel;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.processors.gcp.bigquery.AbstractBigQueryProcessor;
import org.apache.nifi.processors.gcp.bigquery.BigQueryAttributes;
import org.apache.nifi.processors.gcp.bigquery.BigQueryUtils;
import org.apache.nifi.processors.gcp.bigquery.PutBigQuery;
import org.apache.nifi.processors.gcp.storage.DeleteGCSObject;
import org.apache.nifi.processors.gcp.storage.PutGCSObject;
import org.apache.nifi.util.StringUtils;
import org.threeten.bp.Duration;
import org.threeten.bp.temporal.ChronoUnit;
import org.threeten.bp.temporal.TemporalUnit;

@InputRequirement(value=InputRequirement.Requirement.INPUT_REQUIRED)
@DeprecationNotice(alternatives={PutBigQuery.class}, reason="This processor is deprecated and may be removed in future releases.")
@Tags(value={"google", "google cloud", "bq", "bigquery"})
@CapabilityDescription(value="Please be aware this processor is deprecated and may be removed in the near future. Use PutBigQuery instead. Batch loads flow files content to a Google BigQuery table.")
@SeeAlso(value={PutGCSObject.class, DeleteGCSObject.class})
@WritesAttributes(value={@WritesAttribute(attribute="bq.job.stat.creation_time", description="Time load job creation"), @WritesAttribute(attribute="bq.job.stat.end_time", description="Time load job ended"), @WritesAttribute(attribute="bq.job.stat.start_time", description="Time load job started"), @WritesAttribute(attribute="bq.job.link", description="API Link to load job"), @WritesAttribute(attribute="bq.job.id", description="ID of the BigQuery job"), @WritesAttribute(attribute="bq.error.message", description="Load job error message"), @WritesAttribute(attribute="bq.error.reason", description="Load job error reason"), @WritesAttribute(attribute="bq.error.location", description="Load job error location"), @WritesAttribute(attribute="bq.records.count", description="Number of records successfully inserted")})
@Deprecated
public class PutBigQueryBatch
extends AbstractBigQueryProcessor {
    private static final List<String> TYPES = Arrays.asList(FormatOptions.json().getType(), FormatOptions.csv().getType(), FormatOptions.avro().getType());
    private static final Validator FORMAT_VALIDATOR = new Validator(){

        public ValidationResult validate(String subject, String input, ValidationContext context) {
            ValidationResult.Builder builder = new ValidationResult.Builder();
            builder.subject(subject).input(input);
            if (context.isExpressionLanguageSupported(subject) && context.isExpressionLanguagePresent(input)) {
                return builder.valid(true).explanation("Contains Expression Language").build();
            }
            if (TYPES.contains(input.toUpperCase())) {
                builder.valid(true);
            } else {
                builder.valid(false).explanation("Load File Type must be one of the following options: " + StringUtils.join(TYPES, (String)", "));
            }
            return builder.build();
        }
    };
    public static final PropertyDescriptor READ_TIMEOUT = new PropertyDescriptor.Builder().name("bq.readtimeout").displayName("Read Timeout").description("Load Job Time Out").required(true).defaultValue("5 minutes").expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).addValidator(StandardValidators.TIME_PERIOD_VALIDATOR).build();
    public static final PropertyDescriptor TABLE_SCHEMA = new PropertyDescriptor.Builder().name("bq.table.schema").displayName("Table Schema").description("BigQuery schema in JSON format").required(false).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final PropertyDescriptor SOURCE_TYPE = new PropertyDescriptor.Builder().name("bq.load.type").displayName("Load file type").description("Data type of the file to be loaded. Possible values: AVRO, NEWLINE_DELIMITED_JSON, CSV.").required(true).addValidator(FORMAT_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).build();
    public static final PropertyDescriptor CREATE_DISPOSITION = new PropertyDescriptor.Builder().name("bq.load.create_disposition").displayName("Create Disposition").description("Sets whether the job is allowed to create new tables").required(true).allowableValues(new AllowableValue[]{BigQueryAttributes.CREATE_IF_NEEDED, BigQueryAttributes.CREATE_NEVER}).defaultValue(BigQueryAttributes.CREATE_IF_NEEDED.getValue()).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final PropertyDescriptor WRITE_DISPOSITION = new PropertyDescriptor.Builder().name("bq.load.write_disposition").displayName("Write Disposition").description("Sets the action that should occur if the destination table already exists.").required(true).allowableValues(new AllowableValue[]{BigQueryAttributes.WRITE_EMPTY, BigQueryAttributes.WRITE_APPEND, BigQueryAttributes.WRITE_TRUNCATE}).defaultValue(BigQueryAttributes.WRITE_EMPTY.getValue()).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final PropertyDescriptor MAXBAD_RECORDS = new PropertyDescriptor.Builder().name("bq.load.max_badrecords").displayName("Max Bad Records").description("Sets the maximum number of bad records that BigQuery can ignore when running the job. If the number of bad records exceeds this value, an invalid error is returned in the job result. By default no bad record is ignored.").required(true).defaultValue("0").addValidator(StandardValidators.NON_NEGATIVE_INTEGER_VALIDATOR).build();
    public static final PropertyDescriptor CSV_ALLOW_JAGGED_ROWS = new PropertyDescriptor.Builder().name("bq.csv.allow.jagged.rows").displayName("CSV Input - Allow Jagged Rows").description("Set whether BigQuery should accept rows that are missing trailing optional columns. If true, BigQuery treats missing trailing columns as null values. If false, records with missing trailing columns are treated as bad records, and if there are too many bad records, an invalid error is returned in the job result. By default, rows with missing trailing columns are considered bad records.").required(true).allowableValues(new String[]{"true", "false"}).defaultValue("false").build();
    public static final PropertyDescriptor CSV_ALLOW_QUOTED_NEW_LINES = new PropertyDescriptor.Builder().name("bq.csv.allow.quoted.new.lines").displayName("CSV Input - Allow Quoted New Lines").description("Sets whether BigQuery should allow quoted data sections that contain newline characters in a CSV file. By default quoted newline are not allowed.").required(true).allowableValues(new String[]{"true", "false"}).defaultValue("false").build();
    public static final PropertyDescriptor CSV_CHARSET = new PropertyDescriptor.Builder().name("bq.csv.charset").displayName("CSV Input - Character Set").description("Sets the character encoding of the data.").required(true).allowableValues(new String[]{"UTF-8", "ISO-8859-1"}).defaultValue("UTF-8").build();
    public static final PropertyDescriptor CSV_FIELD_DELIMITER = new PropertyDescriptor.Builder().name("bq.csv.delimiter").displayName("CSV Input - Field Delimiter").description("Sets the separator for fields in a CSV file. BigQuery converts the string to ISO-8859-1 encoding, and then uses the first byte of the encoded string to split the data in its raw, binary state. BigQuery also supports the escape sequence \"\t\" to specify a tab separator. The default value is a comma (',').").required(true).defaultValue(",").addValidator(StandardValidators.NON_EMPTY_EL_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).build();
    public static final PropertyDescriptor CSV_QUOTE = new PropertyDescriptor.Builder().name("bq.csv.quote").displayName("CSV Input - Quote").description("Sets the value that is used to quote data sections in a CSV file. BigQuery converts the string to ISO-8859-1 encoding, and then uses the first byte of the encoded string to split the data in its raw, binary state. The default value is a double-quote ('\"'). If your data does not contain quoted sections, set the property value to an empty string. If your data contains quoted newline characters, you must also set the Allow Quoted New Lines property to true.").required(true).defaultValue("\"").addValidator(StandardValidators.NON_EMPTY_EL_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).build();
    public static final PropertyDescriptor CSV_SKIP_LEADING_ROWS = new PropertyDescriptor.Builder().name("bq.csv.skip.leading.rows").displayName("CSV Input - Skip Leading Rows").description("Sets the number of rows at the top of a CSV file that BigQuery will skip when reading the data. The default value is 0. This property is useful if you have header rows in the file that should be skipped.").required(true).defaultValue("0").addValidator(StandardValidators.NON_NEGATIVE_INTEGER_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).build();
    public static final PropertyDescriptor AVRO_USE_LOGICAL_TYPES = new PropertyDescriptor.Builder().name("bq.avro.use.logical.types").displayName("Avro Input - Use Logical Types").description("If format is set to Avro and if this option is set to true, you can interpret logical types into their corresponding types (such as TIMESTAMP) instead of only using their raw types (such as INTEGER).").required(true).allowableValues(new String[]{"true", "false"}).defaultValue("false").build();

    @Override
    public List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        ArrayList<PropertyDescriptor> descriptors = new ArrayList<PropertyDescriptor>(super.getSupportedPropertyDescriptors());
        descriptors.add(TABLE_SCHEMA);
        descriptors.add(READ_TIMEOUT);
        descriptors.add(SOURCE_TYPE);
        descriptors.add(CREATE_DISPOSITION);
        descriptors.add(WRITE_DISPOSITION);
        descriptors.add(MAXBAD_RECORDS);
        descriptors.add(CSV_ALLOW_JAGGED_ROWS);
        descriptors.add(CSV_ALLOW_QUOTED_NEW_LINES);
        descriptors.add(CSV_CHARSET);
        descriptors.add(CSV_FIELD_DELIMITER);
        descriptors.add(CSV_QUOTE);
        descriptors.add(CSV_SKIP_LEADING_ROWS);
        descriptors.add(AVRO_USE_LOGICAL_TYPES);
        return Collections.unmodifiableList(descriptors);
    }

    @Override
    @OnScheduled
    public void onScheduled(ProcessContext context) {
        super.onScheduled(context);
    }

    public void onTrigger(ProcessContext context, ProcessSession session) throws ProcessException {
        FlowFile flowFile = session.get();
        if (flowFile == null) {
            return;
        }
        String type = context.getProperty(SOURCE_TYPE).evaluateAttributeExpressions(flowFile).getValue();
        TableId tableId = this.getTableId(context, flowFile.getAttributes());
        try {
            Object formatOption = type.equals(FormatOptions.csv().getType()) ? FormatOptions.csv().toBuilder().setAllowJaggedRows(context.getProperty(CSV_ALLOW_JAGGED_ROWS).asBoolean().booleanValue()).setAllowQuotedNewLines(context.getProperty(CSV_ALLOW_QUOTED_NEW_LINES).asBoolean().booleanValue()).setEncoding(context.getProperty(CSV_CHARSET).getValue()).setFieldDelimiter(context.getProperty(CSV_FIELD_DELIMITER).evaluateAttributeExpressions(flowFile).getValue()).setQuote(context.getProperty(CSV_QUOTE).evaluateAttributeExpressions(flowFile).getValue()).setSkipLeadingRows((long)context.getProperty(CSV_SKIP_LEADING_ROWS).evaluateAttributeExpressions(flowFile).asInteger().intValue()).build() : FormatOptions.of((String)type);
            Schema schema = BigQueryUtils.schemaFromString(context.getProperty(TABLE_SCHEMA).evaluateAttributeExpressions(flowFile).getValue());
            WriteChannelConfiguration writeChannelConfiguration = WriteChannelConfiguration.newBuilder((TableId)tableId).setCreateDisposition(JobInfo.CreateDisposition.valueOf((String)context.getProperty(CREATE_DISPOSITION).getValue())).setWriteDisposition(JobInfo.WriteDisposition.valueOf((String)context.getProperty(WRITE_DISPOSITION).getValue())).setIgnoreUnknownValues(context.getProperty(IGNORE_UNKNOWN).evaluateAttributeExpressions(flowFile).asBoolean()).setUseAvroLogicalTypes(context.getProperty(AVRO_USE_LOGICAL_TYPES).asBoolean()).setMaxBadRecords(context.getProperty(MAXBAD_RECORDS).asInteger()).setSchema(schema).setFormatOptions(formatOption).build();
            try (TableDataWriteChannel writer = ((BigQuery)this.getCloudService()).writer(writeChannelConfiguration);){
                session.read(flowFile, rawIn -> {
                    ReadableByteChannel readableByteChannel = Channels.newChannel(rawIn);
                    ByteBuffer byteBuffer = ByteBuffer.allocateDirect(65536);
                    while (readableByteChannel.read(byteBuffer) >= 0) {
                        byteBuffer.flip();
                        writer.write(byteBuffer);
                        byteBuffer.clear();
                    }
                });
                writer.close();
                Job job = writer.getJob();
                Long timePeriod = context.getProperty(READ_TIMEOUT).evaluateAttributeExpressions(flowFile).asTimePeriod(TimeUnit.SECONDS);
                Duration waitFor = Duration.of((long)timePeriod, (TemporalUnit)ChronoUnit.SECONDS);
                job = job.waitFor(new RetryOption[]{RetryOption.totalTimeout((Duration)waitFor)});
                if (job != null) {
                    boolean jobError;
                    HashMap<String, String> attributes = new HashMap<String, String>();
                    attributes.put("bq.job.stat.creation_time", Long.toString(job.getStatistics().getCreationTime()));
                    attributes.put("bq.job.stat.end_time", Long.toString(job.getStatistics().getEndTime()));
                    attributes.put("bq.job.stat.start_time", Long.toString(job.getStatistics().getStartTime()));
                    attributes.put("bq.job.link", job.getSelfLink());
                    attributes.put("bq.job.id", job.getJobId().getJob());
                    boolean bl = jobError = job.getStatus().getError() != null;
                    if (jobError) {
                        attributes.put("bq.error.message", job.getStatus().getError().getMessage());
                        attributes.put("bq.error.reason", job.getStatus().getError().getReason());
                        attributes.put("bq.error.location", job.getStatus().getError().getLocation());
                    } else {
                        flowFile = session.removeAttribute(flowFile, "bq.error.message");
                        flowFile = session.removeAttribute(flowFile, "bq.error.reason");
                        flowFile = session.removeAttribute(flowFile, "bq.error.location");
                        if (job.getStatistics() instanceof JobStatistics.LoadStatistics) {
                            JobStatistics.LoadStatistics stats = (JobStatistics.LoadStatistics)job.getStatistics();
                            attributes.put("bq.records.count", Long.toString(stats.getOutputRows()));
                        }
                    }
                    if (!attributes.isEmpty()) {
                        flowFile = session.putAllAttributes(flowFile, attributes);
                    }
                    if (jobError) {
                        this.getLogger().log(LogLevel.WARN, job.getStatus().getError().getMessage());
                        flowFile = session.penalize(flowFile);
                        session.transfer(flowFile, REL_FAILURE);
                    } else {
                        session.getProvenanceReporter().send(flowFile, job.getSelfLink(), job.getStatistics().getEndTime() - job.getStatistics().getStartTime());
                        session.transfer(flowFile, REL_SUCCESS);
                    }
                }
            }
        }
        catch (Exception ex) {
            this.getLogger().log(LogLevel.ERROR, ex.getMessage(), (Throwable)ex);
            flowFile = session.penalize(flowFile);
            session.transfer(flowFile, REL_FAILURE);
        }
    }
}

