/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.flow.resource;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.concurrent.CountDownLatch;
import org.apache.nifi.flow.resource.ConflictResolvingExternalResourceProviderWorker;
import org.apache.nifi.flow.resource.ExternalResourceConflictResolutionStrategy;
import org.apache.nifi.flow.resource.ExternalResourceDescriptor;
import org.apache.nifi.flow.resource.ExternalResourceProvider;
import org.apache.nifi.flow.resource.ExternalResourceProviderException;
import org.apache.nifi.nar.NarCloseable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class CollisionAwareResourceProviderWorker
extends ConflictResolvingExternalResourceProviderWorker {
    private static final Logger LOGGER = LoggerFactory.getLogger(CollisionAwareResourceProviderWorker.class);

    CollisionAwareResourceProviderWorker(String namePrefix, ClassLoader providerClassLoader, ExternalResourceProvider provider, ExternalResourceConflictResolutionStrategy resolutionStrategy, File targetDirectory, long pollTimeInMs, CountDownLatch restrainStartupLatch) {
        super(namePrefix, providerClassLoader, provider, resolutionStrategy, targetDirectory, pollTimeInMs, restrainStartupLatch);
    }

    @Override
    protected void acquireResource(ExternalResourceDescriptor availableResource) throws IOException {
        long startedAt = System.currentTimeMillis();
        File targetFile = new File(this.getTargetDirectory(), availableResource.getLocation());
        File tempFile = new File(this.getTargetDirectory().getPath() + "/.provider_" + this.getId() + "_buffer.tmp");
        File backupFile = new File(this.getTargetDirectory().getPath() + "/.provider_" + this.getId() + "_aside.tmp");
        try (NarCloseable narCloseable = NarCloseable.withComponentNarLoader((ClassLoader)this.getProviderClassLoader());
             InputStream inputStream = this.getProvider().fetchExternalResource(availableResource);){
            if (tempFile.exists() && !tempFile.delete()) {
                throw new ExternalResourceProviderException("Buffer file '" + tempFile.getName() + "' already exists and cannot be deleted");
            }
            Files.copy(inputStream, tempFile.toPath(), new CopyOption[0]);
        }
        if (targetFile.exists() && !targetFile.renameTo(backupFile)) {
            throw new ExternalResourceProviderException("Target file '" + targetFile.getName() + "' already exists and cannot be moved aside");
        }
        if (tempFile.renameTo(targetFile)) {
            LOGGER.info("Downloaded external resource {} in {} ms", (Object)availableResource.getLocation(), (Object)(System.currentTimeMillis() - startedAt));
            if (backupFile.exists() && !backupFile.delete()) {
                LOGGER.error("Could not remove set aside file for {}", (Object)targetFile.getName());
            }
        } else {
            LOGGER.error("Could not put downloaded resource {} in place", (Object)availableResource.getLocation());
            if (!tempFile.delete()) {
                LOGGER.error("Could not delete buffer file for {}", (Object)targetFile.getName());
            }
            if (backupFile.exists() && !backupFile.renameTo(targetFile)) {
                LOGGER.error("After failing to put new file in place, could not revert to the previous file");
            }
        }
    }
}

