/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.repository.io;

import java.io.IOException;
import java.io.OutputStream;

public class DisableOnCloseOutputStream
extends OutputStream {
    private final OutputStream wrapped;
    private boolean closed = false;

    public DisableOnCloseOutputStream(OutputStream toWrap) {
        this.wrapped = toWrap;
    }

    @Override
    public void write(int b) throws IOException {
        if (this.closed) {
            throw new IOException("Stream is closed");
        }
        this.wrapped.write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (this.closed) {
            throw new IOException("Stream is closed");
        }
        this.wrapped.write(b, off, len);
    }

    @Override
    public void write(byte[] b) throws IOException {
        if (this.closed) {
            throw new IOException("Stream is closed");
        }
        this.wrapped.write(b);
    }

    @Override
    public void flush() throws IOException {
        this.wrapped.flush();
    }

    @Override
    public void close() throws IOException {
        this.wrapped.flush();
        this.closed = true;
    }
}

