/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.cluster.manager;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.nifi.cluster.manager.PermissionsDtoMerger;
import org.apache.nifi.cluster.protocol.NodeIdentifier;
import org.apache.nifi.controller.service.ControllerServiceState;
import org.apache.nifi.web.api.dto.AffectedComponentDTO;
import org.apache.nifi.web.api.dto.PermissionsDTO;
import org.apache.nifi.web.api.entity.AffectedComponentEntity;

public class AffectedComponentEntityMerger {
    public void mergeAffectedComponents(Set<AffectedComponentEntity> affectedComponents, Map<NodeIdentifier, Set<AffectedComponentEntity>> affectedComponentMap) {
        HashMap<String, Integer> activeThreadCounts = new HashMap<String, Integer>();
        HashMap<String, String> states = new HashMap<String, String>();
        HashMap<String, PermissionsDTO> canReads = new HashMap<String, PermissionsDTO>();
        HashMap<String, List> bulletins = new HashMap<String, List>();
        for (Map.Entry<NodeIdentifier, Set<AffectedComponentEntity>> nodeEntry : affectedComponentMap.entrySet()) {
            Set<AffectedComponentEntity> nodeAffectedComponents = nodeEntry.getValue();
            if (nodeAffectedComponents == null) continue;
            for (AffectedComponentEntity nodeAffectedComponentEntity : nodeAffectedComponents) {
                AffectedComponentDTO nodeAffectedComponent = nodeAffectedComponentEntity.getComponent();
                if (nodeAffectedComponentEntity.getPermissions().getCanRead().booleanValue()) {
                    String state;
                    if (nodeAffectedComponent.getActiveThreadCount() != null && nodeAffectedComponent.getActiveThreadCount() > 0) {
                        Integer current = (Integer)activeThreadCounts.get(nodeAffectedComponent.getId());
                        if (current == null) {
                            activeThreadCounts.put(nodeAffectedComponent.getId(), nodeAffectedComponent.getActiveThreadCount());
                        } else {
                            activeThreadCounts.put(nodeAffectedComponent.getId(), nodeAffectedComponent.getActiveThreadCount() + current);
                        }
                    }
                    if ((state = (String)states.get(nodeAffectedComponent.getId())) == null) {
                        if (ControllerServiceState.DISABLING.name().equals(nodeAffectedComponent.getState())) {
                            states.put(nodeAffectedComponent.getId(), ControllerServiceState.DISABLING.name());
                        } else if (ControllerServiceState.ENABLING.name().equals(nodeAffectedComponent.getState())) {
                            states.put(nodeAffectedComponent.getId(), ControllerServiceState.ENABLING.name());
                        }
                    }
                    List bulletinsForComponent = bulletins.computeIfAbsent(nodeAffectedComponentEntity.getId(), k -> new ArrayList());
                    List nodeComponentBulletins = nodeAffectedComponentEntity.getBulletins();
                    if (nodeComponentBulletins != null) {
                        bulletinsForComponent.addAll(nodeComponentBulletins);
                    }
                }
                PermissionsDTO mergedPermissions = (PermissionsDTO)canReads.get(nodeAffectedComponentEntity.getId());
                PermissionsDTO permissions = nodeAffectedComponentEntity.getPermissions();
                if (permissions == null) continue;
                if (mergedPermissions == null) {
                    canReads.put(nodeAffectedComponentEntity.getId(), permissions);
                    continue;
                }
                PermissionsDtoMerger.mergePermissions(mergedPermissions, permissions);
            }
        }
        if (affectedComponents != null) {
            for (AffectedComponentEntity affectedComponent : affectedComponents) {
                PermissionsDTO permissions = (PermissionsDTO)canReads.get(affectedComponent.getId());
                if (permissions != null && permissions.getCanRead() != null && permissions.getCanRead().booleanValue()) {
                    String state;
                    Integer activeThreadCount = (Integer)activeThreadCounts.get(affectedComponent.getId());
                    if (activeThreadCount != null) {
                        affectedComponent.getComponent().setActiveThreadCount(activeThreadCount);
                    }
                    if ((state = (String)states.get(affectedComponent.getId())) != null) {
                        affectedComponent.getComponent().setState(state);
                    }
                    affectedComponent.setBulletins((List)bulletins.get(affectedComponent.getId()));
                    continue;
                }
                affectedComponent.setPermissions(permissions);
                affectedComponent.setComponent(null);
                if (affectedComponent.getProcessGroup() != null) {
                    affectedComponent.getProcessGroup().setName(affectedComponent.getProcessGroup().getId());
                }
                affectedComponent.setBulletins(null);
            }
        }
    }
}

