/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.cluster.manager;

import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import org.apache.nifi.cluster.manager.ComponentEntityMerger;
import org.apache.nifi.cluster.manager.ComponentEntityStatusMerger;
import org.apache.nifi.cluster.manager.StatusMerger;
import org.apache.nifi.cluster.protocol.NodeIdentifier;
import org.apache.nifi.web.api.dto.ConnectionDTO;
import org.apache.nifi.web.api.dto.status.ConnectionStatusDTO;
import org.apache.nifi.web.api.entity.ConnectionEntity;

public class ConnectionEntityMerger
implements ComponentEntityMerger<ConnectionEntity>,
ComponentEntityStatusMerger<ConnectionStatusDTO> {
    @Override
    public void merge(ConnectionEntity clientEntity, Map<NodeIdentifier, ConnectionEntity> entityMap) {
        Set selectedRelationships;
        Set availableRelationships;
        boolean anyActive;
        ComponentEntityMerger.super.merge(clientEntity, entityMap);
        for (Map.Entry<NodeIdentifier, ConnectionEntity> entry : entityMap.entrySet()) {
            ConnectionEntity entityStatus = entry.getValue();
            if (entityStatus == clientEntity) continue;
            this.mergeStatus(clientEntity.getStatus(), (boolean)clientEntity.getPermissions().getCanRead(), entry.getValue().getStatus(), (boolean)entry.getValue().getPermissions().getCanRead(), entry.getKey());
        }
        if (clientEntity.getComponent() != null && "LOAD_BALANCE_INACTIVE".equals(clientEntity.getComponent().getLoadBalanceStatus()) && (anyActive = entityMap.values().stream().map(ConnectionEntity::getComponent).filter(Objects::nonNull).map(ConnectionDTO::getLoadBalanceStatus).anyMatch(status -> status.equals("LOAD_BALANCE_ACTIVE")))) {
            clientEntity.getComponent().setLoadBalanceStatus("LOAD_BALANCE_ACTIVE");
        }
        Set set = availableRelationships = clientEntity.getComponent() == null ? null : clientEntity.getComponent().getAvailableRelationships();
        if (availableRelationships != null) {
            clientEntity.getComponent().setAvailableRelationships(new TreeSet(availableRelationships));
        }
        Set set2 = selectedRelationships = clientEntity.getComponent() == null ? null : clientEntity.getComponent().getSelectedRelationships();
        if (selectedRelationships != null) {
            clientEntity.getComponent().setSelectedRelationships(new TreeSet(selectedRelationships));
        }
    }

    @Override
    public void mergeStatus(ConnectionStatusDTO clientStatus, boolean clientStatusReadablePermission, ConnectionStatusDTO status, boolean statusReadablePermission, NodeIdentifier statusNodeIdentifier) {
        StatusMerger.merge(clientStatus, clientStatusReadablePermission, status, statusReadablePermission, statusNodeIdentifier.getId(), statusNodeIdentifier.getApiAddress(), (Integer)statusNodeIdentifier.getApiPort());
    }
}

