/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.cluster.coordination.http.endpoints;

import java.net.URI;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.nifi.cluster.coordination.http.endpoints.AbstractSingleEntityEndpoint;
import org.apache.nifi.cluster.manager.ComponentEntityStatusMerger;
import org.apache.nifi.cluster.manager.NodeResponse;
import org.apache.nifi.cluster.manager.StatusMerger;
import org.apache.nifi.cluster.protocol.NodeIdentifier;
import org.apache.nifi.web.api.dto.status.NodePortStatusSnapshotDTO;
import org.apache.nifi.web.api.dto.status.PortStatusDTO;
import org.apache.nifi.web.api.entity.PortStatusEntity;

public class PortStatusEndpointMerger
extends AbstractSingleEntityEndpoint<PortStatusEntity>
implements ComponentEntityStatusMerger<PortStatusDTO> {
    public static final Pattern INPUT_PORT_STATUS_URI_PATTERN = Pattern.compile("/nifi-api/flow/input-ports/[a-f0-9\\-]{36}/status");
    public static final Pattern OUTPUT_PORT_STATUS_URI_PATTERN = Pattern.compile("/nifi-api/flow/output-ports/[a-f0-9\\-]{36}/status");

    @Override
    public boolean canHandle(URI uri, String method) {
        return "GET".equalsIgnoreCase(method) && (INPUT_PORT_STATUS_URI_PATTERN.matcher(uri.getPath()).matches() || OUTPUT_PORT_STATUS_URI_PATTERN.matcher(uri.getPath()).matches());
    }

    @Override
    protected Class<PortStatusEntity> getEntityClass() {
        return PortStatusEntity.class;
    }

    @Override
    protected void mergeResponses(PortStatusEntity clientEntity, Map<NodeIdentifier, PortStatusEntity> entityMap, Set<NodeResponse> successfulResponses, Set<NodeResponse> problematicResponses) {
        PortStatusDTO mergedPortStatus = clientEntity.getPortStatus();
        mergedPortStatus.setNodeSnapshots(new ArrayList());
        NodeIdentifier selectedNodeId = entityMap.entrySet().stream().filter(e -> e.getValue() == clientEntity).map(e -> (NodeIdentifier)e.getKey()).findFirst().orElse(null);
        if (selectedNodeId == null) {
            throw new IllegalArgumentException("Attempted to merge Status request but could not find the appropriate Node Identifier");
        }
        NodePortStatusSnapshotDTO selectedNodeSnapshot = new NodePortStatusSnapshotDTO();
        selectedNodeSnapshot.setStatusSnapshot(mergedPortStatus.getAggregateSnapshot().clone());
        selectedNodeSnapshot.setAddress(selectedNodeId.getApiAddress());
        selectedNodeSnapshot.setApiPort(Integer.valueOf(selectedNodeId.getApiPort()));
        selectedNodeSnapshot.setNodeId(selectedNodeId.getId());
        mergedPortStatus.getNodeSnapshots().add(selectedNodeSnapshot);
        for (Map.Entry<NodeIdentifier, PortStatusEntity> entry : entityMap.entrySet()) {
            NodeIdentifier nodeId = entry.getKey();
            PortStatusEntity nodePortStatusEntity = entry.getValue();
            PortStatusDTO nodePortStatus = nodePortStatusEntity.getPortStatus();
            if (nodePortStatus == mergedPortStatus) continue;
            this.mergeStatus(mergedPortStatus, (boolean)clientEntity.getCanRead(), nodePortStatus, (boolean)nodePortStatusEntity.getCanRead(), nodeId);
        }
    }

    @Override
    public void mergeStatus(PortStatusDTO clientStatus, boolean clientStatusReadablePermission, PortStatusDTO status, boolean statusReadablePermission, NodeIdentifier statusNodeIdentifier) {
        StatusMerger.merge(clientStatus, clientStatusReadablePermission, status, statusReadablePermission, statusNodeIdentifier.getId(), statusNodeIdentifier.getApiAddress(), (Integer)statusNodeIdentifier.getApiPort());
    }
}

