/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.cluster.coordination.http.endpoints;

import java.net.URI;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.nifi.cluster.coordination.http.EndpointResponseMerger;
import org.apache.nifi.cluster.coordination.http.endpoints.AbstractSingleEntityEndpoint;
import org.apache.nifi.cluster.manager.NodeResponse;
import org.apache.nifi.cluster.manager.PermissionsDtoMerger;
import org.apache.nifi.cluster.protocol.NodeIdentifier;
import org.apache.nifi.web.api.entity.ParameterContextEntity;
import org.apache.nifi.web.api.entity.ParameterContextsEntity;

public class ParameterContextsEndpointMerger
extends AbstractSingleEntityEndpoint<ParameterContextsEntity>
implements EndpointResponseMerger {
    private static final String PARAMETER_CONTEXTS_URI = "/nifi-api/parameter-contexts";

    @Override
    public boolean canHandle(URI uri, String method) {
        return "GET".equalsIgnoreCase(method) && PARAMETER_CONTEXTS_URI.equals(uri.getPath());
    }

    @Override
    protected Class<ParameterContextsEntity> getEntityClass() {
        return ParameterContextsEntity.class;
    }

    @Override
    protected void mergeResponses(ParameterContextsEntity clientEntity, Map<NodeIdentifier, ParameterContextsEntity> entityMap, Set<NodeResponse> successfulResponses, Set<NodeResponse> problematicResponses) {
        HashMap<String, ParameterContextEntity> contextEntities = new HashMap<String, ParameterContextEntity>();
        for (ParameterContextsEntity contextsEntity : entityMap.values()) {
            for (ParameterContextEntity entity : contextsEntity.getParameterContexts()) {
                ParameterContextEntity mergedEntity = (ParameterContextEntity)contextEntities.get(entity.getId());
                if (mergedEntity == null) {
                    contextEntities.put(entity.getId(), entity);
                    continue;
                }
                this.merge(mergedEntity, entity);
            }
        }
        clientEntity.setParameterContexts(new HashSet(contextEntities.values()));
    }

    private void merge(ParameterContextEntity merged, ParameterContextEntity additional) {
        PermissionsDtoMerger.mergePermissions(merged.getPermissions(), additional.getPermissions());
        if (merged.getComponent() == null || additional.getComponent() == null) {
            merged.setComponent(null);
        }
    }
}

