/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.cluster.coordination.http.endpoints;

import java.net.URI;
import java.util.ArrayList;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.nifi.cluster.coordination.http.endpoints.AbstractNodeStatusEndpoint;
import org.apache.nifi.cluster.manager.StatusMerger;
import org.apache.nifi.cluster.protocol.NodeIdentifier;
import org.apache.nifi.web.api.dto.CountersDTO;
import org.apache.nifi.web.api.dto.NodeCountersSnapshotDTO;
import org.apache.nifi.web.api.entity.CountersEntity;

public class CountersEndpointMerger
extends AbstractNodeStatusEndpoint<CountersEntity, CountersDTO> {
    public static final Pattern COUNTERS_URI_PATTERN = Pattern.compile("/nifi-api/counters");

    @Override
    public boolean canHandle(URI uri, String method) {
        return "GET".equalsIgnoreCase(method) && COUNTERS_URI_PATTERN.matcher(uri.getPath()).matches();
    }

    @Override
    protected Class<CountersEntity> getEntityClass() {
        return CountersEntity.class;
    }

    @Override
    protected CountersDTO getDto(CountersEntity entity) {
        return entity.getCounters();
    }

    @Override
    protected void mergeResponses(CountersDTO clientDto, Map<NodeIdentifier, CountersDTO> dtoMap, NodeIdentifier selectedNodeId) {
        CountersDTO mergedCounters = clientDto;
        mergedCounters.setNodeSnapshots(new ArrayList());
        NodeCountersSnapshotDTO selectedNodeSnapshot = new NodeCountersSnapshotDTO();
        selectedNodeSnapshot.setSnapshot(clientDto.getAggregateSnapshot().clone());
        selectedNodeSnapshot.setAddress(selectedNodeId.getApiAddress());
        selectedNodeSnapshot.setApiPort(Integer.valueOf(selectedNodeId.getApiPort()));
        selectedNodeSnapshot.setNodeId(selectedNodeId.getId());
        mergedCounters.getNodeSnapshots().add(selectedNodeSnapshot);
        for (Map.Entry<NodeIdentifier, CountersDTO> entry : dtoMap.entrySet()) {
            NodeIdentifier nodeId = entry.getKey();
            CountersDTO toMerge = entry.getValue();
            if (toMerge == clientDto) continue;
            StatusMerger.merge(mergedCounters, toMerge, nodeId.getId(), nodeId.getApiAddress(), (Integer)nodeId.getApiPort());
        }
    }
}

