/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.cluster.coordination.http.endpoints;

import java.net.URI;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.nifi.cluster.coordination.http.endpoints.AbstractNodeStatusEndpoint;
import org.apache.nifi.cluster.protocol.NodeIdentifier;
import org.apache.nifi.web.api.dto.FlowConfigurationDTO;
import org.apache.nifi.web.api.entity.FlowConfigurationEntity;

public class FlowConfigurationEndpointMerger
extends AbstractNodeStatusEndpoint<FlowConfigurationEntity, FlowConfigurationDTO> {
    public static final Pattern FLOW_CONFIGURATION_URI_PATTERN = Pattern.compile("/nifi-api/flow/config");

    @Override
    public boolean canHandle(URI uri, String method) {
        return "GET".equalsIgnoreCase(method) && FLOW_CONFIGURATION_URI_PATTERN.matcher(uri.getPath()).matches();
    }

    @Override
    protected Class<FlowConfigurationEntity> getEntityClass() {
        return FlowConfigurationEntity.class;
    }

    @Override
    protected FlowConfigurationDTO getDto(FlowConfigurationEntity entity) {
        return entity.getFlowConfiguration();
    }

    @Override
    protected void mergeResponses(FlowConfigurationDTO clientDto, Map<NodeIdentifier, FlowConfigurationDTO> dtoMap, NodeIdentifier selectedNodeId) {
        for (Map.Entry<NodeIdentifier, FlowConfigurationDTO> entry : dtoMap.entrySet()) {
            FlowConfigurationDTO toMerge = entry.getValue();
            if (toMerge == clientDto) continue;
            clientDto.setSupportsConfigurableAuthorizer(Boolean.valueOf(clientDto.getSupportsConfigurableAuthorizer() != false && toMerge.getSupportsConfigurableAuthorizer() != false));
        }
    }
}

